package com.zoyi.channel.plugin.android.activity.chat.dialog;

import androidx.annotation.NonNull;
import android.view.ViewGroup;

import com.zoyi.channel.plugin.android.base.adapter.BaseAdapter;
import com.zoyi.channel.plugin.android.model.rest.Manager;

import java.util.ArrayList;
import java.util.List;

public class ReactionsAdapter extends BaseAdapter<ReactionManagerHolder> {

  private List<Manager> managers = new ArrayList<>();

  public void setManagers(List<Manager> managers) {
    this.managers.clear();
    this.managers.addAll(managers);

    notifyDataSetChanged();
  }

  @NonNull
  @Override
  public ReactionManagerHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int i) {
    return ReactionManagerHolder.newInstance(viewGroup);
  }

  @Override
  public void onBindViewHolder(@NonNull ReactionManagerHolder reactionManagerHolder, int i) {
    reactionManagerHolder.bindManager(this.managers.get(i));
  }

  @Override
  public int getItemCount() {
    return this.managers.size();
  }
}
