package com.zoyi.channel.plugin.android.activity.chat.contract;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.zoyi.channel.plugin.android.activity.chat.model.*;
import com.zoyi.channel.plugin.android.activity.common.chat.ChatContentType;
import com.zoyi.channel.plugin.android.contract.BaseAdapterPresenter;
import com.zoyi.channel.plugin.android.contract.BaseView;
import com.zoyi.channel.plugin.android.enumerate.FetchState;
import com.zoyi.channel.plugin.android.model.entity.ProfileEntity;
import com.zoyi.channel.plugin.android.model.rest.*;
import com.zoyi.channel.plugin.android.model.source.photopicker.PhotoItem;

import java.util.List;

public interface ChatContract {

  interface View extends BaseView {

    void onFetchStateChange(FetchState fetchState);

    void onWelcomeStateChange(ChatContentType contentType, boolean acceptInput);

    void onChatStateChange(UserChat userChat, Message message, boolean acceptInput, boolean temporaryInputOpened, boolean isWorking);

    boolean isScrollOnBottom();

    void scrollToBottom();

    void showNewMessageAlert(ProfileEntity profileEntity);

    void setInputDim(boolean enabled);

    void setTextInput(@Nullable String message);

    boolean isScrollable();
  }

  interface Presenter extends BaseAdapterPresenter {

    void fetchBackwardMessages();

    void sendText(String message);

    void uploadFiles(List<PhotoItem> photoItems);

    void onActionClick(@NonNull String actionType, @NonNull ActionButton actionButton);

    void onCreateSupportBotClick();

    void resend(SendItem item);

    void removeFailedItem(SendItem item);

    void cancelSendingFile(SendFileItem item);

    void updateProfile(ProfileBotMessageItem item, String key, @Nullable Object value);

    void deleteMessage(String userChatId, String messageId);
  }
}
