package com.zoyi.channel.plugin.android.action;

import androidx.annotation.NonNull;

import com.zoyi.channel.plugin.android.enumerate.ActionType;
import com.zoyi.channel.plugin.android.enumerate.FetchState;
import com.zoyi.channel.plugin.android.global.Api;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.model.repo.UserChatsRepo;
import com.zoyi.channel.plugin.android.network.RestSubscriber;
import com.zoyi.channel.plugin.android.network.RetrofitException;
import com.zoyi.channel.plugin.android.store.UserChatStore;

public class UserChatAction {

  public static void fetchUserChats(boolean showClosedChats) {
    UserChatStore.get().userChatsFetchState.set(FetchState.LOADING);

    Api.getUserChats(Const.UPDATED_AT, Const.DESC, Const.USER_CHATS_LIMIT, showClosedChats)
        .runBy(ActionType.REQUEST_USER_CHATS)
        .cancelBy(ActionType.REQUEST_LOUNGE, ActionType.SOCKET_DISCONNECTED, ActionType.MESSENGER_CLOSED, ActionType.SHUTDOWN)
        .run(new RestSubscriber<UserChatsRepo>() {
          @Override
          public void onError(RetrofitException error) {
            UserChatStore.get().userChatsFetchState.set(FetchState.FAILED);
          }

          @Override
          public void onSuccess(@NonNull UserChatsRepo userChatsRepo) {
            userChatsRepo.set();
          }
        });
  }

  public static void fetchUserChats(boolean showClosedChats, String next) {
    UserChatStore.get().userChatsFetchState.set(FetchState.LOADING);

    Api.getUserChats(Const.UPDATED_AT, Const.DESC, Const.USER_CHATS_LIMIT, showClosedChats, next)
        .runBy(ActionType.REQUEST_USER_CHATS_CONTINUOUS)
        .cancelBy(
            ActionType.REQUEST_LOUNGE,
            ActionType.REQUEST_USER_CHATS,
            ActionType.SOCKET_DISCONNECTED,
            ActionType.MESSENGER_CLOSED,
            ActionType.SHUTDOWN
        )
        .run(new RestSubscriber<UserChatsRepo>() {
          @Override
          public void onError(RetrofitException error) {
            UserChatStore.get().userChatsFetchState.set(FetchState.FAILED);
          }

          @Override
          public void onSuccess(@NonNull UserChatsRepo userChatsRepo) {
            userChatsRepo.add();
          }
        });
  }
}
