package com.zoyi.channel.plugin.android.action;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.zoyi.channel.plugin.android.enumerate.ActionType;
import com.zoyi.channel.plugin.android.global.Api;
import com.zoyi.channel.plugin.android.model.repo.UserRepo;
import com.zoyi.channel.plugin.android.network.RestSubscriber;
import com.zoyi.channel.plugin.android.network.RetrofitException;
import com.zoyi.channel.plugin.android.open.callback.UserUpdateCallback;
import com.zoyi.channel.plugin.android.open.exception.ChannelException;
import com.zoyi.channel.plugin.android.open.model.User;

import java.util.List;

public class TagAction {

  public static void addTags(@Nullable List<String> tags, @Nullable UserUpdateCallback callback) {
    Api.addTags(tags)
        .cancelBy(ActionType.SHUTDOWN)
        .run(new RestSubscriber<UserRepo>() {
          @Override
          public void onError(RetrofitException error) {
            if (callback != null) {
              callback.onComplete(ChannelException.newInstance(error.getMessage()), null);
            }
          }

          @Override
          public void onSuccess(@NonNull UserRepo repo) {
            if (callback != null) {
              callback.onComplete(null, User.newInstance(repo.getUser()));
            }
          }
        });
  }

  public static void removeTags(@Nullable List<String> tags, @Nullable UserUpdateCallback callback) {
    Api.removeTags(tags)
        .cancelBy(ActionType.SHUTDOWN)
        .run(new RestSubscriber<UserRepo>() {
          @Override
          public void onError(RetrofitException error) {
            if (callback != null) {
              callback.onComplete(ChannelException.newInstance(error.getMessage()), null);
            }
          }

          @Override
          public void onSuccess(@NonNull UserRepo repo) {
            if (callback != null) {
              callback.onComplete(null, User.newInstance(repo.getUser()));
            }
          }
        });
  }
}
