/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.view.coordinator;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.Shader;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.design.widget.AppBarLayout;
import android.support.v4.view.OnApplyWindowInsetsListener;
import android.support.v4.view.ViewCompat;
import android.support.v4.view.WindowInsetsCompat;
import android.support.v4.widget.NestedScrollView;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.bind.Binder;
import com.zoyi.channel.plugin.android.model.rest.Plugin;
import com.zoyi.channel.plugin.android.selector.PluginSelector;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.util.Views;
import com.zoyi.channel.plugin.android.view.coordinator.OnNestedScrollChangeListener;
import com.zoyi.channel.plugin.android.view.coordinator.OverlayView;
import com.zoyi.rx.functions.Action1;
import java.util.ArrayList;
import java.util.List;

public class GradientHeaderCoordinatorLayout
extends FrameLayout {
    static final String TAG = "GradientHeader";
    private Context context;
    @Nullable
    private AppBarLayout appBarLayout;
    @Nullable
    private NestedScrollView nestedScrollView;
    @Nullable
    private WindowInsetsCompat mLastInsets;
    @Nullable
    private OnApplyWindowInsetsListener mApplyWindowInsetsListener;
    @Nullable
    OnNestedScrollChangeListener onNestedScrollChangeListener;
    private int themeColor = -16777216;
    private int gradientColor = -1;
    private List<View> paddingEffectiveViews = new ArrayList<View>();
    @Nullable
    private Paint backgroundPaint;
    private int headerHeight = 0;
    @Nullable
    private Binder binder;

    public GradientHeaderCoordinatorLayout(@NonNull Context context) {
        super(context);
        this.init(context);
    }

    public GradientHeaderCoordinatorLayout(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public GradientHeaderCoordinatorLayout(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    @Initializer
    private void init(Context context) {
        this.context = context;
        LayoutInflater.from((Context)context).inflate(R.layout.ch_plugin_layout_gradient_header_coordinator, (ViewGroup)this, true);
        if (Views.isFullscreenSupporting()) {
            this.setFitsSystemWindows(true);
            this.setupForInsets();
        }
    }

    private void setupForInsets() {
        if (ViewCompat.getFitsSystemWindows((View)this)) {
            if (this.mApplyWindowInsetsListener == null) {
                this.mApplyWindowInsetsListener = (v, insets) -> {
                    this.applyInsets(insets);
                    return insets;
                };
            }
            ViewCompat.setOnApplyWindowInsetsListener((View)this, (OnApplyWindowInsetsListener)this.mApplyWindowInsetsListener);
            this.setSystemUiVisibility(1280);
        } else {
            ViewCompat.setOnApplyWindowInsetsListener((View)this, null);
        }
    }

    private void applyInsets(WindowInsetsCompat insets) {
        this.mLastInsets = insets;
        this.setPadding(0, 0, 0, 0);
        this.invalidate();
    }

    public void setPadding(int left, int top, int right, int bottom) {
        if (this.mLastInsets != null) {
            super.setPadding(left, top + this.mLastInsets.getSystemWindowInsetTop(), right, bottom);
        } else {
            super.setPadding(left, top, right, bottom);
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.binder = PluginSelector.bindPlugin((Action1<Plugin>)((Action1)plugin -> {
            if (plugin != null) {
                this.refreshColor(plugin.getBackgroundColor(), plugin.getGradientColor());
                this.invalidate();
            }
        }));
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.binder != null) {
            this.binder.unbind();
            this.binder = null;
        }
        this.paddingEffectiveViews.clear();
    }

    private void refreshColor(int themeColor, int gradientColor) {
        this.themeColor = themeColor;
        this.gradientColor = gradientColor;
        this.applyPaint();
        this.invalidate();
    }

    private void refreshHeaderHeight(int headerHeight) {
        this.headerHeight = headerHeight;
        this.applyPaint();
        this.applyContentPadding();
        this.invalidate();
    }

    protected int getBackgroundHeight() {
        return this.mLastInsets != null ? this.mLastInsets.getSystemWindowInsetTop() + this.headerHeight : this.headerHeight;
    }

    private void applyPaint() {
        this.applyPaint(this.getBackgroundHeight());
    }

    protected void applyPaint(int backgroundHeight) {
        if (backgroundHeight > 0) {
            LinearGradient backgroundGradient = new LinearGradient(0.0f, 0.0f, (float)this.getMeasuredWidth(), (float)backgroundHeight, this.themeColor, this.gradientColor, Shader.TileMode.CLAMP);
            if (this.backgroundPaint == null) {
                this.backgroundPaint = new Paint();
            }
            this.backgroundPaint.clearShadowLayer();
            this.backgroundPaint.setShader((Shader)backgroundGradient);
        }
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.drawBackground(canvas);
    }

    protected void drawBackground(Canvas canvas) {
        if (this.backgroundPaint != null) {
            canvas.drawRect(0.0f, 0.0f, (float)this.getWidth(), (float)this.getBackgroundHeight(), this.backgroundPaint);
        }
    }

    public void addView(View child, int index, ViewGroup.LayoutParams params) {
        if (child == null) {
            return;
        }
        if (child.getId() == R.id.ch_rootGradientHeaderCoordinator) {
            super.addView(child, index, params);
            return;
        }
        if (child instanceof AppBarLayout) {
            if (this.appBarLayout == null) {
                this.appBarLayout = (AppBarLayout)child;
                this.appBarLayout.setBackgroundColor(0);
                this.appBarLayout.setFitsSystemWindows(false);
                this.appBarLayout.getViewTreeObserver().addOnGlobalLayoutListener(() -> {
                    if (this.appBarLayout != null && this.appBarLayout.getHeight() != this.headerHeight) {
                        this.refreshHeaderHeight(this.appBarLayout.getHeight());
                        if (this.nestedScrollView != null && this.onNestedScrollChangeListener != null) {
                            this.onNestedScrollChangeListener.onScrollChange(this.nestedScrollView.getScrollY(), this.appBarLayout.getHeight());
                        }
                    }
                });
                super.addView(child, index, params);
                this.invalidate();
            } else {
                Log.e((String)TAG, (String)"AppBarLayout can handle only one");
            }
        } else if (child instanceof NestedScrollView) {
            if (this.nestedScrollView == null) {
                this.nestedScrollView = (NestedScrollView)child;
                this.nestedScrollView.setOnScrollChangeListener((v, scrollX, scrollY, oldScrollX, oldScrollY) -> {
                    if (this.onNestedScrollChangeListener != null) {
                        this.onNestedScrollChangeListener.onScrollChange(scrollY, this.headerHeight);
                    }
                });
                super.addView(child, index, params);
                this.appendPaddingEffectiveViews(child);
            } else {
                Log.e((String)TAG, (String)"NestedScrollView can handle only one");
            }
        } else if (child instanceof OverlayView) {
            super.addView(child, index, params);
        } else {
            FrameLayout frameLayout = new FrameLayout(this.context);
            frameLayout.addView(child, index, params);
            super.addView((View)frameLayout, index, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
            this.appendPaddingEffectiveViews((View)frameLayout);
        }
    }

    private void appendPaddingEffectiveViews(View view) {
        this.paddingEffectiveViews.add(view);
        this.applyContentPadding();
    }

    private void applyContentPadding() {
        for (View view : this.paddingEffectiveViews) {
            view.setPadding(view.getPaddingLeft(), this.headerHeight, view.getPaddingRight(), view.getPaddingBottom());
        }
    }

    public void setOnNestedScrollChangeListener(@Nullable OnNestedScrollChangeListener onNestedScrollChangeListener) {
        this.onNestedScrollChangeListener = onNestedScrollChangeListener;
    }
}

