/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.selector;

import android.support.annotation.Nullable;
import com.zoyi.channel.plugin.android.bind.Binder;
import com.zoyi.channel.plugin.android.model.rest.Channel;
import com.zoyi.channel.plugin.android.model.rest.SupportBotEntry;
import com.zoyi.channel.plugin.android.store.ChannelStore;
import com.zoyi.channel.plugin.android.store.SupportBotStore;
import com.zoyi.channel.plugin.android.store.TimerStore;
import com.zoyi.channel.plugin.android.store.TypingStore;
import com.zoyi.channel.plugin.android.store.binder.Binder1;
import com.zoyi.channel.plugin.android.store.binder.Binder3;
import com.zoyi.channel.plugin.android.store.state.BooleanState;
import com.zoyi.channel.plugin.android.store.state.State;
import com.zoyi.channel.plugin.android.util.ChannelUtils;
import com.zoyi.channel.plugin.android.util.CompareUtils;
import com.zoyi.rx.functions.Action1;
import com.zoyi.rx.functions.Action3;

public class ChannelSelector {
    public static Binder bindChannel(Action1<Channel> action1) {
        State<Channel> channelState = ChannelStore.get().channelState;
        return new Binder1<Channel>(channelState).bind((Action1<Channel>)((Action1)channel -> {
            if (channel != null) {
                action1.call(channel);
            }
        }));
    }

    public static Binder bindDisableStartChat(Action1<Boolean> action1) {
        State<Channel> channelState = ChannelStore.get().channelState;
        State<Long> nowState = TimerStore.get().now;
        State<SupportBotEntry> supportBotState = SupportBotStore.get().supportBotState;
        return new Binder3<Channel, Long, SupportBotEntry>(channelState, nowState, supportBotState).bind((Action3<Channel, Long, SupportBotEntry>)((Action3)(channel, now, supportBot) -> {
            if (channel == null) {
                action1.call((Object)true);
            } else {
                action1.call((Object)(!ChannelUtils.isWorking(channel, now) && CompareUtils.exists((Comparable)((Object)channel.getAwayOption()), (Comparable[])new String[]{"disabled", "hidden"}) && supportBot == null ? 1 : 0));
            }
        }));
    }

    public static Binder bindAcceptInput(Action1<Boolean> action1) {
        State<Channel> channelState = ChannelStore.get().channelState;
        State<Long> nowState = TimerStore.get().now;
        BooleanState typingState = TypingStore.get().typingState;
        return new Binder3<Channel, Long, Boolean>(channelState, nowState, typingState).bind((Action3<Channel, Long, Boolean>)((Action3)(channel, now, isTyping) -> action1.call((Object)ChannelSelector.shouldAcceptAction(channel, now, isTyping))));
    }

    static boolean shouldAcceptAction(@Nullable Channel channel, @Nullable Long now, Boolean isTyping) {
        if (isTyping != null && isTyping.booleanValue()) {
            return true;
        }
        if (channel != null && now != null) {
            return "active".equals(channel.getAwayOption()) || ChannelUtils.isWorking(channel, now);
        }
        return false;
    }
}

