/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chat.viewholder;

import android.support.annotation.Nullable;
import android.view.View;
import android.widget.TextView;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.base.adapter.BaseViewHolder;
import com.zoyi.channel.plugin.android.open.option.Language;
import com.zoyi.channel.plugin.android.store.SettingsStore;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.TimeUtils;
import com.zoyi.channel.plugin.android.util.Views;
import com.zoyi.rx.Subscription;

public abstract class AbsMessageHolder
extends BaseViewHolder {
    private static final Long cutOff = 86400000L;
    private View viewHead;
    private View viewTail;
    private TextView textDate;
    private TextView textCreatedAt;
    @Nullable
    private Subscription subscription;

    AbsMessageHolder(View itemView) {
        super(itemView);
        this.viewHead = itemView.findViewById(R.id.ch_layoutMessageHolderHead);
        this.viewTail = itemView.findViewById(R.id.ch_viewMessageHolderTailPadding);
        this.textDate = (TextView)itemView.findViewById(R.id.ch_textMessageHolderDate);
        this.textCreatedAt = (TextView)itemView.findViewById(R.id.ch_textMessageHolderTime);
    }

    public void bind(Long createdAt, boolean showDate, boolean isHead, boolean isTail) {
        this.clearSubscription();
        Views.setVisibility(this.viewHead, isHead);
        Views.setVisibility(this.viewTail, isTail);
        this.textCreatedAt.setText((CharSequence)TimeUtils.getTime(createdAt));
        if (this.textDate != null && showDate && createdAt != null) {
            this.textDate.setVisibility(0);
            if (TimeUtils.isSameDate(createdAt).booleanValue()) {
                this.textDate.setText((CharSequence)ResUtils.getString("ch.day_divider.today"));
                this.subscription = TimeUtils.wait(TimeUtils.calculateUntilTomorrow(), () -> this.textDate.setText((CharSequence)TimeUtils.formatTranslatedDate(createdAt, (Language)((Object)((Object)SettingsStore.get().language.get())))));
            } else {
                this.textDate.setText((CharSequence)TimeUtils.formatTranslatedDate(createdAt, (Language)((Object)SettingsStore.get().language.get())));
            }
        } else if (this.textDate != null) {
            this.textDate.setVisibility(8);
        }
    }

    @Override
    protected void onRecycled() {
        super.onRecycled();
        this.clearSubscription();
    }

    private void clearSubscription() {
        if (this.subscription != null && !this.subscription.isUnsubscribed()) {
            this.subscription.unsubscribe();
        }
        this.subscription = null;
    }
}

