/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chat.view.viewholder;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.action.TranslateAction;
import com.zoyi.channel.plugin.android.activity.chat.view.viewholder.MessageContentView;
import com.zoyi.channel.plugin.android.bind.Binder;
import com.zoyi.channel.plugin.android.enumerate.TranslationState;
import com.zoyi.channel.plugin.android.model.etc.TranslationInfo;
import com.zoyi.channel.plugin.android.selector.TranslationSelector;
import com.zoyi.channel.plugin.android.store.TranslationStore;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.Views;
import com.zoyi.channel.plugin.android.view.external.cpv.CircularProgressView;
import com.zoyi.rx.functions.Action1;

public class TranslationContentView
extends FrameLayout
implements MessageContentView {
    private CircularProgressView progressView;
    private TextView textView;
    @Nullable
    private Binder translationBinder;
    @Nullable
    private String chatId;
    @Nullable
    private String messageId;
    @Nullable
    private String language;

    public TranslationContentView(@NonNull Context context) {
        super(context);
        this.init(context);
    }

    public TranslationContentView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public TranslationContentView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    @Initializer
    private void init(Context context) {
        LayoutInflater.from((Context)context).inflate(R.layout.ch_holder_message_content_translation, (ViewGroup)this);
        this.progressView = (CircularProgressView)this.findViewById(R.id.ch_progressMessageTranslation);
        this.textView = (TextView)this.findViewById(R.id.ch_textMessageTranslateState);
        this.textView.setOnClickListener(v -> {
            if (this.chatId != null && this.messageId != null && this.language != null) {
                String translationKey = TranslationInfo.createKey(this.chatId, this.messageId, this.language);
                TranslationInfo translationInfo = (TranslationInfo)TranslationStore.get().translation.get(translationKey);
                if (translationInfo != null) {
                    switch (translationInfo.getState()) {
                        case ORIGIN: {
                            translationInfo.setState(TranslationState.TRANSLATED);
                            break;
                        }
                        case TRANSLATED: {
                            translationInfo.setState(TranslationState.ORIGIN);
                        }
                    }
                    TranslationStore.get().translation.upsert(translationInfo);
                } else {
                    TranslateAction.translate(this.chatId, this.messageId, this.language);
                }
            }
        });
    }

    public void bind(@Nullable String chatId, @Nullable String messageId, String language) {
        this.chatId = chatId;
        this.messageId = messageId;
        this.language = language;
        String translationKey = TranslationInfo.createKey(chatId, messageId, language);
        this.translationBinder = TranslationSelector.bindTranslation(translationKey, (Action1<TranslationInfo>)((Action1)translationInfo -> {
            if (translationInfo == null || translationInfo.getState() == TranslationState.ORIGIN) {
                Views.setVisibility(this.progressView, false, 4);
                Views.setVisibility((View)this.textView, true, 4);
                this.textView.setText((CharSequence)ResUtils.getString(this.getContext(), "ch.show_translate"));
            } else if (translationInfo.getState() == TranslationState.PROGRESS) {
                Views.setVisibility(this.progressView, true, 4);
                Views.setVisibility((View)this.textView, false, 4);
            } else if (translationInfo.getState() == TranslationState.TRANSLATED) {
                Views.setVisibility(this.progressView, false, 4);
                Views.setVisibility((View)this.textView, true, 4);
                this.textView.setText((CharSequence)ResUtils.getString(this.getContext(), "ch.undo_translate"));
            } else {
                Views.setVisibility(this.progressView, false, 4);
                Views.setVisibility((View)this.textView, false, 4);
            }
        }));
    }

    @Override
    public void resetView() {
    }

    @Override
    public void clear() {
        this.chatId = null;
        this.messageId = null;
        this.language = null;
        if (this.translationBinder != null) {
            this.translationBinder.unbind();
            this.translationBinder = null;
        }
    }
}

