package com.zoyi.channel.plugin.android.selector;

import android.support.annotation.Nullable;

import com.zoyi.channel.plugin.android.bind.Binder;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.model.entity.ProfileEntity;
import com.zoyi.channel.plugin.android.model.etc.PushEvent;
import com.zoyi.channel.plugin.android.model.rest.*;
import com.zoyi.channel.plugin.android.open.model.PopupData;
import com.zoyi.channel.plugin.android.store.*;
import com.zoyi.channel.plugin.android.store.binder.*;
import com.zoyi.channel.plugin.android.store.state.BooleanState;
import com.zoyi.channel.plugin.android.store.state.State;
import com.zoyi.channel.plugin.android.util.ChannelUtils;
import com.zoyi.com.annimon.stream.Optional;
import com.zoyi.rx.functions.Action1;
import com.zoyi.rx.functions.Action3;

public class GlobalSelector {

  public static Binder bindBootState(Action1<Boolean> action1) {
    return new Binder1<>(GlobalStore.get().bootState).bind(action1::call);
  }

  public static Binder bindMessengerVisibility(Action1<Boolean> action1) {
    return new Binder1<>(GlobalStore.get().messengerState).bind(action1);
  }

  public static Binder bindLauncherVisibility(Action1<Boolean> action1) {
    BooleanState bootState = GlobalStore.get().bootState;
    BooleanState showLauncherState = SettingsStore.get().showLauncher;

    return new Binder2<>(bootState, showLauncherState).bind((isBooted, showLauncher) ->
        action1.call(isBooted && showLauncher)
    );
  }

  private static boolean getLauncherVisibility(boolean showLauncher, Channel channel, Long now) {
    if (!showLauncher || now == null || channel == null) {
      return false;
    }
    return ChannelUtils.isWorking(channel, now) || !Const.AWAY_OPTION_HIDDEN.equals(channel.getAwayOption());
  }

  public static boolean getLauncherVisibility() {
    return getLauncherVisibility(
        SettingsStore.get().showLauncher.get(),
        ChannelStore.get().channelState.get(),
        TimerStore.get().now.get()
    );
  }

  public static Binder bindPopup(Action1<PopupData> action1) {
    State<Message> popupMessageState = PopupStore.get().popupMessage;

    return new Binder1<>(popupMessageState).bind((message) -> {
      if (message != null) {
        ProfileEntity profile = ProfileSelector.getProfile(message.getPersonType(), message.getPersonId());

        if (profile != null) {
          action1.call(new PopupData(message, profile));
        }
      }
    });
  }

  public static Binder bindLegacyInAppPush(Action1<PushEvent> action1) {
    State<Message> inAppPushMessageState = PopupStore.get().popupMessage;

    return new Binder1<>(inAppPushMessageState).bind((message) -> {
      if (message != null) {
        ProfileEntity profile = ProfileSelector.getProfile(message.getPersonType(), message.getPersonId());

        if (profile != null) {
          action1.call(new PushEvent(message, profile));
        }
      }
    });
  }

  public static Binder bindLauncherStyle(Action3<Plugin, Integer, Boolean> action3) {
    State<Plugin> pluginState = PluginStore.get().pluginState;
    State<Message> popupMessageState = PopupStore.get().popupMessage;
    State<User> userState = UserStore.get().user;

    return new Binder3<>(
        pluginState,
        popupMessageState,
        userState
    ).bind((plugin, popupMessage, user) -> {
      if (plugin != null) {
        int count = user != null ? user.getAlert() : 0;
        boolean isMarketingVisible = popupMessage != null && popupMessage.getMarketing() != null;

        action3.call(plugin, count, isMarketingVisible);
      }
    });
  }

  @Nullable
  public static String getTopActivityName() {
    return Optional.ofNullable(GlobalStore.get().topActivity.get()).map(activity -> activity.getClass().getSimpleName()).orElse(null);
  }
}
