package com.zoyi.channel.plugin.android.model.repo;

import com.zoyi.channel.plugin.android.action.MarketingAction;
import com.zoyi.channel.plugin.android.model.rest.*;
import com.zoyi.channel.plugin.android.store.BotStore;
import com.zoyi.channel.plugin.android.store.ManagerStore;
import com.zoyi.com.annimon.stream.Stream;

import java.util.List;

/**
 * Created by mika on 2016. 12. 8..
 */
public class MessagesRepo extends BaseRepo {

  private String next;
  private List<Message> messages;
  private List<Manager> managers;
  private List<Bot> bots;

  public String getNext() {
    return next;
  }

  public List<Message> getMessages() {
    return messages;
  }

  @Override
  public void update() {
    ManagerStore.get().managers.add(managers);
    BotStore.get().bots.add(bots);

    Stream.ofNullable(messages)
        .filter(message -> message.getMarketing() != null)
        .map(Message::getMarketing)
        .forEach(MarketingAction::sendViewEvent);
  }
}
