package com.zoyi.channel.plugin.android.activity.chat.view.viewholder;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.TextView;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.action.TranslateAction;
import com.zoyi.channel.plugin.android.enumerate.TranslationState;
import com.zoyi.channel.plugin.android.model.etc.TranslationInfo;
import com.zoyi.channel.plugin.android.selector.TranslationSelector;
import com.zoyi.channel.plugin.android.store.TranslationStore;
import com.zoyi.channel.plugin.android.bind.Binder;
import com.zoyi.channel.plugin.android.util.*;
import com.zoyi.channel.plugin.android.view.external.cpv.CircularProgressView;

public class TranslationContentView extends FrameLayout implements MessageContentView {

  public TranslationContentView(@NonNull Context context) {
    super(context);

    init(context);
  }

  public TranslationContentView(@NonNull Context context, @Nullable AttributeSet attrs) {
    super(context, attrs);

    init(context);
  }

  public TranslationContentView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
    super(context, attrs, defStyleAttr);

    init(context);
  }

  private CircularProgressView progressView;
  private TextView textView;

  @Nullable
  private Binder translationBinder;

  @Nullable
  private String chatId;
  @Nullable
  private String messageId;
  @Nullable
  private String language;

  @Initializer
  private void init(Context context) {
    LayoutInflater.from(context).inflate(R.layout.ch_holder_message_content_translation, this);

    progressView = findViewById(R.id.ch_progressMessageTranslation);
    textView = findViewById(R.id.ch_textMessageTranslateState);

    textView.setOnClickListener(v -> {
      if (chatId != null && messageId != null && language != null) {
        String translationKey = TranslationInfo.createKey(chatId, messageId, language);
        TranslationInfo translationInfo = TranslationStore.get().translation.get(translationKey);

        if (translationInfo != null) {
          switch (translationInfo.getState()) {
            case ORIGIN:
              translationInfo.setState(TranslationState.TRANSLATED);
              break;

            case TRANSLATED:
              translationInfo.setState(TranslationState.ORIGIN);
              break;
          }

          TranslationStore.get().translation.upsert(translationInfo);
        } else {
          TranslateAction.translate(chatId, messageId, language);
        }
      }
    });
  }

  public void bind(@Nullable String chatId, @Nullable String messageId, String language) {
    this.chatId = chatId;
    this.messageId = messageId;
    this.language = language;

    String translationKey = TranslationInfo.createKey(chatId, messageId, language);

    this.translationBinder = TranslationSelector.bindTranslation(translationKey, translationInfo -> {
      if (translationInfo == null || translationInfo.getState() == TranslationState.ORIGIN) {
        Views.setVisibility(progressView, false, View.INVISIBLE);
        Views.setVisibility(textView, true, View.INVISIBLE);
        textView.setText(ResUtils.getString(getContext(), "ch.show_translate"));
      } else if (translationInfo.getState() == TranslationState.PROGRESS) {
        Views.setVisibility(progressView, true, View.INVISIBLE);
        Views.setVisibility(textView, false, View.INVISIBLE);
      } else if (translationInfo.getState() == TranslationState.TRANSLATED) {
        Views.setVisibility(progressView, false, View.INVISIBLE);
        Views.setVisibility(textView, true, View.INVISIBLE);
        textView.setText(ResUtils.getString(getContext(), "ch.undo_translate"));
      } else {
        Views.setVisibility(progressView, false, View.INVISIBLE);
        Views.setVisibility(textView, false, View.INVISIBLE);
      }
    });
  }

  @Override
  public void resetView() {
    // do nothing
  }

  @Override
  public void clear() {
    this.chatId = null;
    this.messageId = null;
    this.language = null;

    if (translationBinder != null) {
      translationBinder.unbind();
      translationBinder = null;
    }
  }
}
