package com.zoyi.channel.plugin.android.activity.chat.view.reactions;

import android.content.Context;
import android.graphics.Typeface;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.AppCompatImageView;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.widget.FrameLayout;
import android.widget.TextView;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.util.*;
import com.zoyi.com.bumptech.glide.Glide;
import com.zoyi.com.bumptech.glide.load.engine.DiskCacheStrategy;

public class ReactionsTabView extends FrameLayout {

  public ReactionsTabView(@NonNull Context context) {
    super(context);

    init(context);
  }

  public ReactionsTabView(@NonNull Context context, @Nullable AttributeSet attrs) {
    super(context, attrs);

    init(context);
  }

  private Context context;
  private AppCompatImageView imageReactionItem;
  private TextView textReactionItemCount;

  @Initializer
  private void init(Context context) {
    LayoutInflater.from(context).inflate(R.layout.ch_view_reactions_tab, this);

    this.context = context;

    imageReactionItem = findViewById(R.id.ch_imageReactionItem);
    textReactionItemCount = findViewById(R.id.ch_textReactionItemCount);
  }

  public void bind(String emojiName, @Nullable Integer count) {
    Glide.with(context)
        .load(String.format(Const.EMOJI_BASE_URL, AssetUtils.urlEncode(emojiName)))
        .centerCrop()
        .dontAnimate()
        .diskCacheStrategy(DiskCacheStrategy.SOURCE)
        .into(imageReactionItem);

    textReactionItemCount.setText(Utils.getCount(count != null ? count : 0, false));
  }

  public void setBold(boolean bold) {
    textReactionItemCount.setTypeface(null, bold ? Typeface.BOLD : Typeface.NORMAL);
  }
}
