package com.zoyi.channel.plugin.android.activity.chat.model;

import android.support.annotation.Nullable;

import com.zoyi.channel.plugin.android.activity.chat.type.MessageType;
import com.zoyi.channel.plugin.android.model.rest.Log;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.util.TimeUtils;

public class LogMessageItem implements MessageItem {

  private Message message;
  private Log log;

  public LogMessageItem(Message message) {
    this.message = message;
    this.log = message.getLog();
  }

  @Override
  public Long getPrimaryKey() {
    return message.getCreatedAt();
  }

  @Override
  public String getSecondaryKey() {
    return message != null ? message.getId() : "";
  }

  @Override
  public MessageType getType() {
    return MessageType.LOG;
  }

  public Log getLog() {
    return log;
  }

  public boolean isCloseLog() {
    return log != null && log.isClose();
  }

  @Nullable
  public String getCreatedTime() {
    String result = null;

    if (message != null) {
      result = TimeUtils.getTime(message.getCreatedAt());
    }
    return result;
  }
}
