/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.view.media_thumbnail;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.model.rest.WebPage;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.UriUtils;
import com.zoyi.channel.plugin.android.util.Utils;
import com.zoyi.channel.plugin.android.view.media_thumbnail.MediaThumbnailView;
import com.zoyi.channel.plugin.android.view.video_player.YouTubeVideoPlayerView;

public class WebPageMediaThumbnailView
extends MediaThumbnailView {
    private Context context;
    @Nullable
    private String messageId;
    @Nullable
    private WebPage webPage;

    public WebPageMediaThumbnailView(@NonNull Context context) {
        super(context);
        this.init(context);
    }

    public WebPageMediaThumbnailView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public WebPageMediaThumbnailView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    @Initializer
    private void init(Context context) {
        this.context = context;
        this.setBorderRadius(Float.valueOf(Utils.dpToPx(context, 6.0f)));
        this.setBorderWidth(Utils.dpToPx(context, 1.0f));
        this.setBorderColor(ResUtils.getColor(context, R.color.ch_grey300));
    }

    public void setWebPage(@Nullable String messageId, WebPage webPage) {
        this.messageId = messageId;
        this.webPage = webPage;
        this.setImage(webPage.getPreviewUrl());
        if ("YouTube".equals(webPage.getPublisher())) {
            this.activatePlayButton();
        }
    }

    @Override
    public void onPlayClick() {
        if (this.webPage != null && this.webPage.getId() != null && this.webPage.getUrl() != null) {
            super.onPlayClick();
            String videoId = UriUtils.getYouTubeVideoId(this.webPage.getUrl());
            if ("YouTube".equals(this.webPage.getPublisher()) && videoId != null) {
                this.appendVideoView(new YouTubeVideoPlayerView(this.context)).setVideoId(this.messageId, this.webPage.getId(), videoId);
            }
        }
    }
}

