/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chat.view.reactions;

import android.content.Context;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.design.widget.TabLayout;
import android.util.AttributeSet;
import android.util.Pair;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.chat.dialog.OnReactionsTabChangeListener;
import com.zoyi.channel.plugin.android.activity.chat.view.reactions.ReactionsTabView;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.util.Utils;
import java.util.List;

public class ReactionsTabLayout
extends FrameLayout {
    private Context context;
    private TabLayout tabReactions;
    @Nullable
    private OnReactionsTabChangeListener listener;

    public ReactionsTabLayout(@NonNull Context context) {
        super(context);
        this.init(context);
    }

    public ReactionsTabLayout(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    @Initializer
    private void init(Context context) {
        LayoutInflater.from((Context)context).inflate(R.layout.ch_view_reactions_tab_layout, (ViewGroup)this);
        this.context = context;
        this.tabReactions = (TabLayout)this.findViewById(R.id.ch_tabReactions);
        if (Build.VERSION.SDK_INT >= 21 && !this.tabReactions.getClipToPadding() && this.tabReactions.getChildAt(0) instanceof ViewGroup) {
            ViewGroup realTabLayout = (ViewGroup)this.tabReactions.getChildAt(0);
            realTabLayout.setClipToPadding(false);
            realTabLayout.setPadding((int)Utils.dpToPx(context, 12.0f), 0, (int)Utils.dpToPx(context, 12.0f), 0);
        }
        this.tabReactions.addOnTabSelectedListener((TabLayout.BaseOnTabSelectedListener)new TabLayout.OnTabSelectedListener(){

            public void onTabSelected(TabLayout.Tab tab) {
                ReactionsTabLayout.this.setBold(tab, true);
                if (ReactionsTabLayout.this.listener != null) {
                    ReactionsTabLayout.this.listener.onTabChanged(tab.getPosition());
                }
            }

            public void onTabUnselected(TabLayout.Tab tab) {
                ReactionsTabLayout.this.setBold(tab, false);
            }

            public void onTabReselected(TabLayout.Tab tab) {
                ReactionsTabLayout.this.setBold(tab, true);
            }
        });
    }

    public void setTabs(List<Pair<String, Integer>> reactionData) {
        for (Pair<String, Integer> data : reactionData) {
            ReactionsTabView tabView = new ReactionsTabView(this.context);
            tabView.bind((String)data.first, (Integer)data.second);
            this.tabReactions.addTab(this.tabReactions.newTab().setCustomView((View)tabView));
        }
    }

    private void setBold(TabLayout.Tab tab, boolean bold) {
        if (tab.getCustomView() instanceof ReactionsTabView) {
            ((ReactionsTabView)tab.getCustomView()).setBold(bold);
        }
    }

    public void setListener(@Nullable OnReactionsTabChangeListener listener) {
        this.listener = listener;
    }
}

