package com.zoyi.channel.plugin.android.model.repo;

import com.zoyi.channel.plugin.android.ChannelIO;
import com.zoyi.channel.plugin.android.global.PrefSupervisor;
import com.zoyi.channel.plugin.android.model.rest.*;
import com.zoyi.channel.plugin.android.store.*;

/**
 * Created by mika on 2016. 12. 6..
 */
public class PluginRepo extends BaseRepo {

  private Plugin plugin;
  private Channel channel;
  private User user;
  private String sessionJWT;
  private String veilId;

  public Plugin getPlugin() {
    return plugin;
  }

  public Channel getChannel() {
    return channel;
  }

  public User getUser() {
    return user;
  }

  public String getSessionJWT() {
    return sessionJWT;
  }

  public String getVeilId() {
    return veilId;
  }

  @Override
  public void set() {
    PluginStore.get().pluginState.set(plugin);
    ChannelStore.get().channelState.set(channel);
    UserStore.get().user.set(getUser());
    GlobalStore.get().veilId.set(getVeilId());
    GlobalStore.get().jwt.set(getSessionJWT());
    PrefSupervisor.setJwt(ChannelIO.getAppContext(), getSessionJWT());
    PrefSupervisor.setVeilId(ChannelIO.getAppContext(), getVeilId());
  }

  @Override
  public boolean isValid() {
    return plugin != null && channel != null && user != null;
  }
}
