/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.view.youtube.player.util;

import android.view.View;
import android.view.ViewGroup;
import com.zoyi.channel.plugin.android.view.youtube.player.listener.YouTubePlayerFullScreenListener;
import java.util.HashSet;
import java.util.Set;

public class FullScreenHelper {
    private View targetView;
    private boolean isFullScreen;
    private Set<YouTubePlayerFullScreenListener> fullScreenListeners;

    public FullScreenHelper(View targetView) {
        this.targetView = targetView;
        this.isFullScreen = false;
        this.fullScreenListeners = new HashSet<YouTubePlayerFullScreenListener>();
    }

    public boolean isFullScreen() {
        return this.isFullScreen;
    }

    public void enterFullScreen() {
        if (this.isFullScreen) {
            return;
        }
        this.isFullScreen = true;
        ViewGroup.LayoutParams viewParams = this.targetView.getLayoutParams();
        viewParams.height = -1;
        viewParams.width = -1;
        this.targetView.setLayoutParams(viewParams);
        for (YouTubePlayerFullScreenListener fullScreenListener : this.fullScreenListeners) {
            fullScreenListener.onYouTubePlayerEnterFullScreen();
        }
    }

    public void exitFullScreen() {
        if (!this.isFullScreen) {
            return;
        }
        this.isFullScreen = false;
        ViewGroup.LayoutParams viewParams = this.targetView.getLayoutParams();
        viewParams.height = -2;
        viewParams.width = -1;
        this.targetView.setLayoutParams(viewParams);
        for (YouTubePlayerFullScreenListener fullScreenListener : this.fullScreenListeners) {
            fullScreenListener.onYouTubePlayerExitFullScreen();
        }
    }

    public void toggleFullScreen() {
        if (this.isFullScreen) {
            this.exitFullScreen();
        } else {
            this.enterFullScreen();
        }
    }

    public boolean addFullScreenListener(YouTubePlayerFullScreenListener fullScreenListener) {
        return this.fullScreenListeners.add(fullScreenListener);
    }

    public boolean removeFullScreenListener(YouTubePlayerFullScreenListener fullScreenListener) {
        return this.fullScreenListeners.remove(fullScreenListener);
    }
}

