package com.zoyi.channel.plugin.android.view.button;

import android.content.Context;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.util.Initializer;

public class TextButton extends FrameLayout implements ThemeEffectiveView {

  private TextView textView;

  public TextButton(Context context) {
    super(context);
    init(context);
  }

  public TextButton(Context context, @Nullable AttributeSet attrs) {
    super(context, attrs);
    init(context);
  }

  public TextButton(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
    super(context, attrs, defStyleAttr);
    init(context);
  }

  @Initializer
  private void init(Context context) {
    View view = LayoutInflater.from(context).inflate(R.layout.ch_plugin_view_text_button, this, true);

    textView = view.findViewById(R.id.ch_textButtonText);
  }

  @Override
  public void onThemeChange(int backColor, int textColor) {
    textView.setTextColor(textColor);
  }

  public void setText(@Nullable String text) {
    textView.setText(text);
  }

  public void setTextColor(int textColor) {
    textView.setTextColor(textColor);
  }
}
