package com.zoyi.channel.plugin.android.view.dialog.bottom_sheet.icon_button;

import android.content.Context;
import android.support.annotation.*;
import android.support.v7.widget.AppCompatImageView;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.TextView;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.util.ResUtils;

public class IconButtonView extends FrameLayout {

  private AppCompatImageView imageIconButton;
  private TextView textIconButton;

  public IconButtonView(@NonNull Context context) {
    super(context);
    init(context);
  }

  public IconButtonView(@NonNull Context context, @Nullable AttributeSet attrs) {
    super(context, attrs);
    init(context);
  }

  public IconButtonView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
    super(context, attrs, defStyleAttr);
    init(context);
  }

  private void init(Context context) {
    View view = LayoutInflater.from(context).inflate(R.layout.ch_view_icon_button, this, true);

    imageIconButton = view.findViewById(R.id.ch_imageIconButton);
    textIconButton = view.findViewById(R.id.ch_textIconButton);
  }

  public void setData(@DrawableRes int iconDrawableId, String messageText, int iconColorId, int textColorId) {
    if (iconDrawableId != 0) {
      imageIconButton.setImageResource(iconDrawableId);
    }
    if (iconColorId != 0) {
      imageIconButton.setColorFilter(ResUtils.getColor(iconColorId));
    }

    if (messageText != null) {
      textIconButton.setText(messageText);
    }
    if (textColorId != 0) {
      textIconButton.setTextColor(ResUtils.getColor(textColorId));
    }
  }
}
