package com.zoyi.channel.plugin.android.util;

import android.support.annotation.Nullable;

import com.zoyi.com.google.gson.Gson;
import com.zoyi.com.google.gson.GsonBuilder;
import com.zoyi.okhttp3.RequestBody;

import java.util.HashMap;
import java.util.Map;

import static com.zoyi.okhttp3.MediaType.parse;

/**
 * Created by mika on 8/9/16.
 */
public class RequestUtils {

  HashMap<String, Object> map;

  private Gson gson;

  private Gson getGson() {
    if (gson == null) {
      gson = new GsonBuilder().serializeNulls().create();
    }
    return gson;
  }

  public static RequestUtils form() {
    RequestUtils requestUtils = new RequestUtils();
    requestUtils.map = new HashMap<>();

    return requestUtils;
  }

  public static RequestUtils form(Map<String, Object> map) {
    return form(map, false);
  }

  public static RequestUtils form(Map<String, Object> map, boolean allowNullValue) {
    RequestUtils requestUtils = form();
    if (map != null) {
      for (Map.Entry<String, Object> kvp : map.entrySet()) {
        if (kvp.getKey() != null && (allowNullValue || kvp.getValue() != null)) {
          requestUtils.set(kvp.getKey(), kvp.getValue());
        }
      }
    }
    return requestUtils;
  }

  public RequestUtils set(String key, @Nullable Object value) {
    if (map == null) {
      throw new NullPointerException("You must call \'form\' first");
    }

    map.put(key, value);
    return this;
  }

  public RequestBody create() {
    if (map == null) {
      throw new NullPointerException("You must call \'form\' first");
    }

    return RequestBody.create(
        parse("application/json; charset=utf-8"),
        getGson().toJson(map));
  }

  public int size() {
    if (map == null) {
      return 0;
    }
    return map.size();
  }
}
