package com.zoyi.channel.plugin.android.model.rest;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.model.entity.Entity;
import com.zoyi.channel.plugin.android.model.entity.PersonEntity;
import com.zoyi.channel.plugin.android.util.TimeUtils;
import com.zoyi.com.annimon.stream.Stream;

import java.util.List;

/**
 * Created by mika on 2016. 12. 6..
 */
public class Message implements Entity, PersonEntity {

  private String id;
  @Nullable
  private String channelId;
  @Nullable
  private String chatType;
  @Nullable
  private String chatId;
  @Nullable
  private String personType;
  @Nullable
  private String personId;
  @Nullable
  private List<Block> blocks;
  @Nullable
  private String plainText;
  @Nullable
  private Long createdAt;
  @Nullable
  private String requestId;
  @Nullable
  private List<File> files;
  @Nullable
  private WebPage webPage;
  @Nullable
  private Log log;
  @Nullable
  private List<ProfileBot> profileBot;
  @Nullable
  private MessageAction action;
  @Nullable
  private String language;
  @Nullable
  private String state;
  @Nullable
  private Marketing marketing;
  @Nullable
  private List<Button> buttons;
  @Nullable
  private List<Reaction> reactions;

  public Message() {
  }

  @Override
  public String getId() {
    return id;
  }

  @Nullable
  public String getChatId() {
    return chatId;
  }

  @Nullable
  public String getPersonType() {
    return personType;
  }

  @Nullable
  public String getPersonId() {
    return personId;
  }

  @Nullable
  public List<Block> getBlocks() {
    if (!isDeleted()) {
      return blocks;
    }
    return null;
  }

  public boolean hasBlocks() {
    return blocks != null && !blocks.isEmpty();
  }

  @NonNull
  public String getPlainText() {
    if (plainText != null) {
      return plainText;
    }
    return "";
  }

  public void setPlainText(@Nullable String plainText) {
    this.plainText = plainText;
  }

  @NonNull
  public Long getCreatedAt() {
    if (createdAt == null) {
      return TimeUtils.getCurrentTime();
    }
    return createdAt;
  }

  @Nullable
  public String getRequestId() {
    return requestId;
  }

  @Nullable
  public List<File> getFiles() {
    if (!isDeleted()) {
      return files;
    }
    return null;
  }

  public boolean containsPreviewableFile() {
    return !Stream.ofNullable(files)
        .filter(File::isPreviewable)
        .toList().isEmpty();
  }

  @Nullable
  public WebPage getWebPage() {
    if (!isDeleted()) {
      return webPage;
    }
    return null;
  }

  @Nullable
  public Log getLog() {
    return log;
  }

  @Nullable
  public List<ProfileBot> getProfileBot() {
    return profileBot;
  }

  @Nullable
  public MessageAction getAction() {
    return action;
  }

  @Nullable
  public String getState() {
    return state;
  }

  @Nullable
  public String getLanguage() {
    return language;
  }

  public void clearAction() {
    this.action = null;
  }

  public boolean isDeleted() {
    return Const.MESSAGE_STATE_REMOVED.equals(state);
  }

  @Nullable
  public Marketing getMarketing() {
    return marketing;
  }

  @Nullable
  public List<Button> getButtons() {
    return buttons;
  }

  @Nullable
  public List<Reaction> getReactions() {
    return reactions;
  }

  @Nullable
  public File getPrimaryFile() {
    if (files == null || files.isEmpty()) {
      return null;
    }

    for (File file : files) {
      if (file.isVideo()) {
        return file;
      }
    }

    for (File file : files) {
      if (file.isImage()) {
        return file;
      }
    }

    return files.get(0);
  }

  public boolean hasContents() {
    return blocks != null || buttons!= null || webPage != null || files != null;
  }

  public final static String CLASSNAME = "message";
}
