package com.zoyi.channel.plugin.android.activity.download;

import android.Manifest;
import android.graphics.Color;
import android.net.Uri;
import android.support.annotation.Nullable;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.Toast;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.base.BaseActivity2;
import com.zoyi.channel.plugin.android.enumerate.ButtonType;
import com.zoyi.channel.plugin.android.enumerate.Transition;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.util.FileUtils;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.util.rxpermission.RxPermissions;
import com.zoyi.channel.plugin.android.view.dialog.ChannelDialog;
import com.zoyi.channel.plugin.android.view.handler.SimpleAnimationListener;
import com.zoyi.channel.plugin.android.view.layout.DownloadProgressBar;

/**
 * Created by mika on 2017. 1. 11..
 */
public class DownloadActivity extends BaseActivity2 implements DownloadContract.View, View.OnClickListener {

  private DownloadProgressBar progress;
  private View imageDone;
  private View buttonCancel;

  private DownloadContract.Presenter presenter;

  @Initializer
  @Override
  protected boolean onCreate() {
    init(R.layout.ch_plugin_activity_download, Color.BLACK, false);

    progress = findViewById(R.id.ch_progressDownload);
    imageDone = findViewById(R.id.ch_imageDownloadDone);
    buttonCancel = findViewById(R.id.ch_buttonDownloadCancel);

    buttonCancel.setOnClickListener(this);

    presenter = new DownloadPresenter(this, this);
    bindPresenter(presenter);

    if (getIntent() != null) {
      String url = getIntent().getStringExtra(Const.EXTRA_URL);
      String filename = getIntent().getStringExtra(Const.EXTRA_FILE_NAME);
      String type = getIntent().getStringExtra(Const.EXTRA_TYPE);

      if (url != null && filename != null) {
        new RxPermissions(this)
            .request(Manifest.permission.WRITE_EXTERNAL_STORAGE)
            .subscribe(granted -> {
              if (granted && presenter != null) {
                presenter.download(url, filename, type);
              } else {
                finish(Const.DOWNLOAD_FAILED);
              }
            });
        return true;
      }
    }
    return false;
  }

  @Override
  public void onBackPressed() {
    // ignore back press
  }

  @Override
  public void finish(int resultCode) {
    super.finish(resultCode, Transition.NONE);
  }

  @Override
  protected void onPause() {
    super.onPause();
    overridePendingTransition(0, 0);
  }

  @Override
  public void onClick(View view) {
    int id = view.getId();

    if (id == R.id.ch_buttonDownloadCancel) {
      presenter.cancel();
    }
    finish(Const.DOWNLOAD_CANCEL);
  }

  @Override
  public void onProgressUpdate(int progress) {
    this.progress.setProgress(progress);
  }

  @Override
  public void onError(@Nullable String message) {
    if (message != null) {
      new ChannelDialog(this)
          .setDescription(message)
          .addButton(ButtonType.OK, v -> finish(Const.DOWNLOAD_FAILED))
          .show();
    } else {
      finish(Const.DOWNLOAD_FAILED);
    }
  }

  @Override
  public void onDownloadComplete(Uri uri, String filename, boolean open) {
    imageDone.setVisibility(View.VISIBLE);
    buttonCancel.setVisibility(View.GONE);
    progress.setVisibility(View.GONE);

    if (open) {
      try {
        FileUtils.openFile(this, uri);
      } catch (Exception ex) {
        Toast.makeText(this, ex.getMessage(), Toast.LENGTH_SHORT).show();
      }
    }

    Animation animation = AnimationUtils.loadAnimation(this, R.anim.ch_plugin_dialog_in);
    animation.setAnimationListener(new SimpleAnimationListener() {
      @Override
      public void onAnimationEnd(Animation animation) {
        finish(Const.DOWNLOAD_COMPLETE);
      }
    });
    imageDone.startAnimation(animation);
  }
}
