/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.global;

import android.content.Context;
import android.content.SharedPreferences;
import android.support.annotation.Nullable;
import com.zoyi.channel.plugin.android.open.config.BootConfig;

public class PrefSupervisor {
    private static final String VEIL_ID = "X-Veil-Id";
    private static final String DEVICE_ID = "Device-Id";
    private static final String DEVICE_TOKEN = "Device-Token";
    private static final String SENT_DEVICE_TOKEN = "Sent-Device-Token";
    private static final String SHOW_CLOSED_CHAT = "Show-Closed-Chat-V2";
    private static final String ENABLE_PUSH_ALARM = "Enable-Push-Alarm";
    private static final String ENABLE_TRANSLATE_MESSAGE = "Enable-Translate-Message";
    private static final String JWT = "Jwt_Token";
    private static final String LATEST_BOOT_CONFIG = "LATEST_BOOT_CONFIG";
    private static final String LATEST_BOOTED_PLUGIN_ID = "LATEST_BOOTED_PLUGIN_ID";
    private static final String LATEST_BOOTED_USER_ID = "LATEST_BOOTED_USER_ID";
    private static final String LATEST_PUSH_USER_ID = "LATEST_PUSH_USER_ID";
    private static final String LATEST_PUSH_CHAT_ID = "LATEST_PUSH_CHAT_ID";

    @Nullable
    public static String getVeilId(@Nullable Context context) {
        return PrefSupervisor.getString(context, VEIL_ID);
    }

    public static void setVeilId(@Nullable Context context, @Nullable String veilId) {
        PrefSupervisor.setString(context, VEIL_ID, veilId);
    }

    @Nullable
    public static String getDeviceId(Context context) {
        return PrefSupervisor.getString(context, DEVICE_ID);
    }

    public static void setDeviceId(Context context, String deviceId) {
        PrefSupervisor.setString(context, DEVICE_ID, deviceId);
    }

    @Nullable
    public static String getDeviceToken(Context context) {
        return PrefSupervisor.getString(context, DEVICE_TOKEN);
    }

    public static void setDeviceToken(Context context, String token) {
        PrefSupervisor.setString(context, DEVICE_TOKEN, token);
    }

    @Nullable
    public static String getSentDeviceToken(Context context) {
        return PrefSupervisor.getString(context, SENT_DEVICE_TOKEN);
    }

    public static void setSentDeviceToken(Context context, @Nullable String token) {
        PrefSupervisor.setString(context, SENT_DEVICE_TOKEN, token);
    }

    public static boolean isShownClosedChat(Context context) {
        return PrefSupervisor.getBoolean(context, SHOW_CLOSED_CHAT, true);
    }

    public static void setShowClosedChat(Context context, boolean show) {
        PrefSupervisor.setBoolean(context, SHOW_CLOSED_CHAT, show);
    }

    public static boolean isEnabledPopupAlarm(Context context) {
        return PrefSupervisor.getBoolean(context, ENABLE_PUSH_ALARM, true);
    }

    public static void setPopupAlarm(Context context, boolean enabled) {
        PrefSupervisor.setBoolean(context, ENABLE_PUSH_ALARM, enabled);
    }

    public static boolean canTranslateMessage(Context context) {
        return PrefSupervisor.getBoolean(context, ENABLE_TRANSLATE_MESSAGE, true);
    }

    public static void setTranslateOption(Context context, boolean enable) {
        PrefSupervisor.setBoolean(context, ENABLE_TRANSLATE_MESSAGE, enable);
    }

    @Nullable
    public static String getJwt(@Nullable Context context) {
        return PrefSupervisor.getString(context, JWT);
    }

    public static void setJwt(@Nullable Context context, @Nullable String jwt) {
        PrefSupervisor.setString(context, JWT, jwt);
    }

    public static boolean hasLatestBootData(@Nullable Context context) {
        return PrefSupervisor.getLatestBootConfig(context) != null && PrefSupervisor.getLatestBootedUserId(context) != null;
    }

    @Nullable
    public static BootConfig getLatestBootConfig(@Nullable Context context) {
        return BootConfig.fromJson(PrefSupervisor.getString(context, LATEST_BOOT_CONFIG));
    }

    @Nullable
    public static String getLatestBootedPluginId(@Nullable Context context) {
        return PrefSupervisor.getString(context, LATEST_BOOTED_PLUGIN_ID);
    }

    @Nullable
    public static String getLatestBootedUserId(@Nullable Context context) {
        return PrefSupervisor.getString(context, LATEST_BOOTED_USER_ID);
    }

    public static void setLatestBootData(@Nullable Context context, @Nullable BootConfig bootConfig, @Nullable String pluginId, @Nullable String userId) {
        PrefSupervisor.openTransaction(context, editor -> {
            editor.putString(LATEST_BOOT_CONFIG, bootConfig != null ? bootConfig.toJson() : null);
            editor.putString(LATEST_BOOTED_PLUGIN_ID, pluginId);
            editor.putString(LATEST_BOOTED_USER_ID, userId);
        });
    }

    public static void clearLatestBootData(@Nullable Context context) {
        PrefSupervisor.setLatestBootData(context, null, null, null);
    }

    public static boolean hasLatestPushData(@Nullable Context context) {
        return PrefSupervisor.getLatestPushUserId(context) != null && PrefSupervisor.getLatestPushChatId(context) != null;
    }

    @Nullable
    public static String getLatestPushUserId(@Nullable Context context) {
        return PrefSupervisor.getString(context, LATEST_PUSH_USER_ID);
    }

    @Nullable
    public static String getLatestPushChatId(@Nullable Context context) {
        return PrefSupervisor.getString(context, LATEST_PUSH_CHAT_ID);
    }

    public static void setLatestPushData(@Nullable Context context, @Nullable String userId, @Nullable String chatId) {
        PrefSupervisor.openTransaction(context, editor -> {
            editor.putString(LATEST_PUSH_USER_ID, userId);
            editor.putString(LATEST_PUSH_CHAT_ID, chatId);
        });
    }

    public static void clearLatestPushData(@Nullable Context context) {
        PrefSupervisor.setLatestPushData(context, null, null);
    }

    private static SharedPreferences getPreferences(Context context) {
        return context.getSharedPreferences("CHANNEL_PLUGIN_PRIVATE_DATA", 0);
    }

    private static boolean getBoolean(@Nullable Context context, String key, boolean defaultValue) {
        if (context != null) {
            return PrefSupervisor.getPreferences(context).getBoolean(key, defaultValue);
        }
        return defaultValue;
    }

    @Nullable
    private static String getString(@Nullable Context context, String key) {
        if (context != null) {
            return PrefSupervisor.getPreferences(context).getString(key, null);
        }
        return null;
    }

    private static void setBoolean(@Nullable Context context, String key, boolean value) {
        PrefSupervisor.openTransaction(context, editor -> editor.putBoolean(key, value));
    }

    private static void setString(@Nullable Context context, String key, @Nullable String value) {
        PrefSupervisor.openTransaction(context, editor -> editor.putString(key, value));
    }

    private static void openTransaction(@Nullable Context context, OnTransactionCallback callback) {
        if (context != null) {
            SharedPreferences.Editor editor = PrefSupervisor.getPreferences(context).edit();
            callback.onTransactionOpened(editor);
            editor.apply();
        }
    }

    private static interface OnTransactionCallback {
        public void onTransactionOpened(SharedPreferences.Editor var1);
    }
}

