/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chat.view.attachment;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.IntRange;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnAttachmentContentActionListener;
import com.zoyi.channel.plugin.android.activity.chat.view.viewholder.MessageContentView;
import com.zoyi.channel.plugin.android.model.rest.File;
import com.zoyi.channel.plugin.android.view.media_thumbnail.MediaThumbnailView;
import com.zoyi.channel.plugin.android.view.media_thumbnail.SquareAttachmentMediaThumbnailView;
import com.zoyi.com.annimon.stream.Stream;
import java.util.List;

public class AttachmentGroupGridLayout
extends ViewGroup
implements MessageContentView {
    private Context context;
    private int margin = 0;
    @IntRange(from=1L)
    private int columnSize = 1;

    public AttachmentGroupGridLayout(Context context) {
        super(context);
        this.init(context, null);
    }

    public AttachmentGroupGridLayout(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public AttachmentGroupGridLayout(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Context context, @Nullable AttributeSet attrs) {
        this.context = context;
        if (attrs != null) {
            TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.AttachmentGroupGridLayout);
            try {
                this.margin = typedArray.getDimensionPixelSize(R.styleable.AttachmentGroupGridLayout_ch_aggl_margin, 0);
                this.columnSize = Math.max(typedArray.getInt(R.styleable.AttachmentGroupGridLayout_ch_aggl_columnSize, this.columnSize), 1);
            }
            finally {
                typedArray.recycle();
            }
        }
    }

    public void setAttachments(@Nullable String messageId, List<File> files, @Nullable OnAttachmentContentActionListener listener) {
        this.clear();
        Stream.ofNullable(files).forEachIndexed((index, file) -> {
            switch (file.getType()) {
                case "video": 
                case "image": {
                    SquareAttachmentMediaThumbnailView view = new SquareAttachmentMediaThumbnailView(this.context);
                    view.setAttachment(messageId, (File)file, listener);
                    this.addView((View)view);
                }
            }
        });
    }

    @Override
    public void resetView() {
        if (this.getChildCount() > 0) {
            this.clear();
            this.removeAllViews();
        }
    }

    @Override
    public void clear() {
        if (this.getChildCount() > 0) {
            for (int i = 0; i < this.getChildCount(); ++i) {
                View view = this.getChildAt(i);
                if (!(view instanceof MediaThumbnailView)) continue;
                ((MediaThumbnailView)view).clear();
            }
        }
    }

    protected void onMeasure(int widthSpec, int heightSpec) {
        int width = View.MeasureSpec.getSize((int)widthSpec);
        int availableWidth = View.MeasureSpec.getSize((int)widthSpec) - this.getPaddingLeft() - this.getPaddingRight();
        int verticalPadding = this.getPaddingTop() + this.getPaddingBottom();
        int count = this.getChildCount();
        int contentSize = Math.max(0, (availableWidth - (this.columnSize - 1) * this.margin) / this.columnSize);
        int rowCount = (count + 1) / this.columnSize;
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            child.measure(View.MeasureSpec.makeMeasureSpec((int)contentSize, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)contentSize, (int)0x40000000));
        }
        this.setMeasuredDimension(width, contentSize * rowCount + this.margin * Math.max(0, rowCount - 1) + verticalPadding);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        int width = right - left;
        int availableWidth = width - this.getPaddingLeft() - this.getPaddingRight();
        int count = this.getChildCount();
        int contentSize = Math.max(0, (availableWidth - (this.columnSize - 1) * this.margin) / this.columnSize);
        int appendSize = contentSize + this.margin;
        int topPoint = this.getPaddingTop();
        int leftPoint = this.getPaddingLeft();
        for (int i = 0; i < count; ++i) {
            View view = this.getChildAt(i);
            if (view.getVisibility() == 8) continue;
            view.layout(i % this.columnSize * appendSize + leftPoint, i / this.columnSize * appendSize + topPoint, i % this.columnSize * appendSize + contentSize + leftPoint, i / this.columnSize * appendSize + contentSize + topPoint);
        }
    }
}

