/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mint;

import android.content.Context;
import com.splunk.mint.BaseDTO;
import com.splunk.mint.DataSaver;
import com.splunk.mint.InterfaceDataType;
import com.splunk.mint.NetSender;
import com.splunk.mint.Properties;
import java.util.HashMap;
import org.json.JSONException;
import org.json.JSONObject;

public class ActionNetwork
extends BaseDTO
implements InterfaceDataType {
    private String url = "";
    private Long latency = 0L;
    private Integer statusCode = 0;
    private String responseLength = "NA";
    private String requestLength = "NA";
    private String exception = "NA";
    private String protocol = "NA";

    public ActionNetwork(byte type, String url, HashMap<String, Object> customData) {
        super(type, customData);
        this.url = url;
    }

    public static final void logNetwork(String url, long startT, long endT, String protocol, int statusCode, String requestLength, String responseLength, String exception, HashMap<String, Object> customData) {
        ActionNetwork mActionNetwork = new ActionNetwork(6, url, customData);
        mActionNetwork.latency = endT - startT;
        if (startT == 0L || endT == 0L || mActionNetwork.latency > 180000L) {
            mActionNetwork.latency = 0L;
        }
        mActionNetwork.statusCode = statusCode;
        mActionNetwork.responseLength = responseLength;
        mActionNetwork.requestLength = requestLength;
        mActionNetwork.exception = exception;
        mActionNetwork.protocol = protocol;
        mActionNetwork.save();
    }

    @Override
    public String toJsonLine() {
        JSONObject json = this.getBasicDataFixtureJson();
        try {
            json.put("url", (Object)ActionNetwork.stripHttpFromUrl(this.url));
            json.put("latency", (Object)this.latency);
            json.put("responseLength", (Object)this.responseLength);
            json.put("requestLength", (Object)this.requestLength);
            json.put("protocol", (Object)this.protocol);
            json.put("statusCode", (Object)this.statusCode);
            if (this.exception == null || this.exception.length() == 0) {
                this.exception = "NA";
            }
            json.put("exception", (Object)this.exception);
            if (this.statusCode <= 0) {
                json.put("failed", true);
            } else {
                json.put("failed", false);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return json.toString() + Properties.getSeparator((byte)6);
    }

    private static final String stripHttpFromUrl(String originalUrl) {
        if (originalUrl != null) {
            if (originalUrl.toLowerCase().startsWith("http://")) {
                return originalUrl.replaceFirst("(?i)http://", "");
            }
            if (originalUrl.toLowerCase().startsWith("https://")) {
                return originalUrl.replaceFirst("(?i)https://", "");
            }
        }
        return originalUrl;
    }

    @Override
    public void send(Context ctx, boolean saveOnFail) {
        NetSender.send(this.toJsonLine(), saveOnFail);
    }

    @Override
    public void save() {
        DataSaver.save(this.toJsonLine());
    }

    @Override
    public void send(boolean saveOnFail) {
        NetSender.send(this.toJsonLine(), saveOnFail);
    }
}

