/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chat.dialog;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.RecyclerView;
import android.util.Pair;
import android.view.LayoutInflater;
import android.view.View;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.chat.dialog.ReactionsAdapter;
import com.zoyi.channel.plugin.android.activity.chat.view.reactions.ReactionsTabLayout;
import com.zoyi.channel.plugin.android.enumerate.ActionType;
import com.zoyi.channel.plugin.android.global.Api;
import com.zoyi.channel.plugin.android.model.repo.ManagersRepo;
import com.zoyi.channel.plugin.android.model.rest.Reaction;
import com.zoyi.channel.plugin.android.network.RestSubscriber;
import com.zoyi.channel.plugin.android.network.RetrofitException;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.util.Views;
import com.zoyi.channel.plugin.android.view.dialog.bottom_sheet.BaseBottomSheetDialog;
import com.zoyi.com.annimon.stream.Collectors;
import com.zoyi.com.annimon.stream.Stream;
import com.zoyi.rx.Subscription;
import java.util.List;

public class ReactionsDialog
extends BaseBottomSheetDialog {
    @NonNull
    private ReactionsTabLayout reactionsTabLayout;
    private RecyclerView recyclerViewReactions;
    private View progressReactions;
    private ReactionsAdapter adapter;
    private List<Reaction> reactions;
    @Nullable
    private Subscription subscription;

    @Initializer
    public ReactionsDialog(@NonNull Context context, List<Reaction> reactions) {
        super(context);
        this.reactions = reactions;
        View contentView = LayoutInflater.from((Context)context).inflate(R.layout.ch_dialog_reactions, null);
        this.addContentView(contentView);
        this.setOnDismissListener(dialog -> this.cancelApi());
        this.adapter = new ReactionsAdapter();
        this.reactionsTabLayout = (ReactionsTabLayout)contentView.findViewById(R.id.ch_viewReactionsTab);
        this.reactionsTabLayout.setListener(this::setIndex);
        this.recyclerViewReactions = (RecyclerView)contentView.findViewById(R.id.ch_recyclerViewReactions);
        this.recyclerViewReactions.setAdapter((RecyclerView.Adapter)this.adapter);
        this.progressReactions = contentView.findViewById(R.id.ch_progressReactions);
        this.reactionsTabLayout.setTabs((List)Stream.ofNullable(reactions).map(reaction -> new Pair((Object)reaction.getEmojiName(), (Object)reaction.getCount())).collect(Collectors.toList()));
        this.setIndex(0);
    }

    private void setIndex(int index) {
        if (index < this.reactions.size()) {
            this.cancelApi();
            this.setProgress(true);
            this.subscription = Api.getManagers(this.reactions.get(index).getManagerIds()).cancelBy(ActionType.SHUTDOWN).run(new RestSubscriber<ManagersRepo>(){

                @Override
                public void onError(RetrofitException error) {
                    ReactionsDialog.this.setProgress(false);
                }

                @Override
                public void onSuccess(@NonNull ManagersRepo repo) {
                    ReactionsDialog.this.setProgress(false);
                    ReactionsDialog.this.adapter.setManagers(repo.getManagers());
                    ReactionsDialog.this.recyclerViewReactions.scrollToPosition(0);
                }
            });
        }
    }

    private void setProgress(boolean show) {
        Views.setVisibility(this.progressReactions, show);
        Views.setVisibility((View)this.recyclerViewReactions, !show, 4);
    }

    private void cancelApi() {
        if (this.subscription != null && !this.subscription.isUnsubscribed()) {
            this.subscription.unsubscribe();
        }
        this.subscription = null;
    }
}

