package com.zoyi.channel.plugin.android.view.layout;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.FrameLayout;
import com.zoyi.channel.plugin.android.R;

public class BorderBackgroundView extends FrameLayout {

  private View backColorView;

  public BorderBackgroundView(@NonNull Context context) {
    super(context);
    init(context, null);
  }

  public BorderBackgroundView(@NonNull Context context, @Nullable AttributeSet attrs) {
    super(context, attrs);
    init(context, attrs);
  }

  public BorderBackgroundView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
    super(context, attrs, defStyleAttr);
    init(context, attrs);
  }

  private void init(@NonNull Context context, @Nullable AttributeSet attrs) {
    View view = LayoutInflater.from(context).inflate(R.layout.ch_view_border_background, this, true);

    MaskableFrameLayout maskableFrameLayout = view.findViewById(R.id.ch_layoutMaskBorderBackground);
    backColorView = view.findViewById(R.id.ch_viewColorBorderBackground);

    if (attrs != null) {
      TypedArray typedArray = context.getTheme().obtainStyledAttributes(
          attrs,
          R.styleable.BorderBackgroundView,
          0,
          0);

      try {
        maskableFrameLayout.setMask(typedArray.getDrawable(R.styleable.BorderBackgroundView_ch_bbv_mask));
        setColor(typedArray.getColor(R.styleable.BorderBackgroundView_ch_bbv_backColor, Color.TRANSPARENT));
      } finally {
        typedArray.recycle();
      }
    }
  }

  public void setColor(int color) {
    if (backColorView != null) {
      backColorView.setBackgroundColor(color);
    }
  }
}
