package com.zoyi.channel.plugin.android.store.state;

import android.support.annotation.NonNull;

public class BooleanState extends State<Boolean> {

  public BooleanState(boolean initValue) {
    super(initValue, (oldbie, newbie) -> {
      if (newbie == null) {
        return false;
      }
      if (oldbie == null) {
        return true;
      }
      return oldbie != newbie;
    });
  }

  @NonNull
  @Override
  public Boolean get() {
    Boolean value = super.get();

    if (value != null) {
      return value;
    }
    return defaultData;
  }
}
