package com.zoyi.channel.plugin.android.deserializer;

import com.zoyi.channel.plugin.android.util.ParseUtils;
import com.zoyi.com.google.gson.*;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;

public class AnyMapDeserializer implements JsonDeserializer<Map<String, Object>> {

  @Override
  public Map<String, Object> deserialize(
      JsonElement jsonElement,
      Type type,
      JsonDeserializationContext jsonDeserializationContext
  ) throws JsonParseException {
    try {
      Map<String, Object> map = (Map<String, Object>) ParseUtils.parseJsonElement(jsonElement);

      if (map != null) {
        return map;
      }
    } catch (Exception ex) {
    }
    return new HashMap<>();
  }
}
