package com.zoyi.channel.plugin.android.activity.download;

import android.net.Uri;
import android.support.annotation.Nullable;

import com.zoyi.channel.plugin.android.contract.BasePresenter;
import com.zoyi.channel.plugin.android.contract.BaseView;

public interface DownloadContract {

  interface View extends BaseView {
    void onProgressUpdate(int progress);
    void onError(@Nullable String message);
    void onDownloadComplete(Uri uri, String filename, boolean open);
  }

  interface Presenter extends BasePresenter {
    void download(String url, String filename, @Nullable String type);
    void cancel();
  }
}
