package com.zoyi.channel.plugin.android.action;

import android.support.annotation.NonNull;
import com.zoyi.channel.plugin.android.enumerate.ActionType;
import com.zoyi.channel.plugin.android.enumerate.TranslationState;
import com.zoyi.channel.plugin.android.global.Api;
import com.zoyi.channel.plugin.android.model.etc.TranslationInfo;
import com.zoyi.channel.plugin.android.model.repo.TranslationRepo;
import com.zoyi.channel.plugin.android.network.RestSubscriber;
import com.zoyi.channel.plugin.android.network.RetrofitException;
import com.zoyi.channel.plugin.android.store.TranslationStore;

public class TranslateAction {
  public static void translate(String chatId, String messageId, String language) {
    String translationKey = TranslationInfo.createKey(chatId, messageId, language);

    TranslationStore.get().translation.upsert(TranslationInfo.createProgressStateInfo(translationKey));

    Api.getTranslatedMessage(chatId, messageId, language)
        .cancelBy(ActionType.CHAT_CLOSED, ActionType.SHUTDOWN)
        .run(new RestSubscriber<TranslationRepo>() {
          @Override
          public void onError(RetrofitException error) {
            TranslationStore.get().translation.removeByKey(translationKey);
          }

          @Override
          public void onSuccess(@NonNull TranslationRepo repo) {
            TranslationStore.get().translation.upsert(
                new TranslationInfo(translationKey, repo.getBlocks(), TranslationState.TRANSLATED)
            );
          }
        });
  }
}
