/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.push;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import com.zoyi.channel.plugin.android.ChannelIO;
import com.zoyi.channel.plugin.android.global.PrefSupervisor;
import com.zoyi.channel.plugin.android.open.listener.ChannelPluginListener;

public class ChannelBroadcastReceiver
extends BroadcastReceiver {
    static final String ACTION_CHANNEL_PLUGIN_PUSH_CLICK = "com.zoyi.channel.plugin.android.push.CHANNEL_PUSH_CLICK";

    public void onReceive(Context context, Intent intent) {
        if (intent != null && intent.getAction() != null && ACTION_CHANNEL_PLUGIN_PUSH_CLICK.equals(intent.getAction())) {
            this.handlePushClick(context, intent);
        }
    }

    private void handlePushClick(Context context, Intent intent) {
        Intent hostIntent = (Intent)intent.getParcelableExtra("host_app_intent");
        if (hostIntent == null) {
            return;
        }
        String channelId = hostIntent.getStringExtra("channelId");
        String personType = hostIntent.getStringExtra("personType");
        String personId = hostIntent.getStringExtra("personId");
        String chatId = hostIntent.getStringExtra("chatId");
        if (channelId != null && chatId != null && "user".equals(personType) && personId != null) {
            boolean handled;
            PrefSupervisor.setLatestPushData(context, personId, chatId);
            ChannelPluginListener listener = ChannelIO.getListener();
            if (listener != null && (handled = listener.onPushNotificationClicked(chatId))) {
                return;
            }
            context.startActivity(hostIntent);
        }
    }
}

