/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.photo_picker;

import android.content.Context;
import android.support.annotation.Nullable;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.photo_picker.OnPhotoClickListener;
import com.zoyi.channel.plugin.android.model.etc.MarginBox;
import com.zoyi.channel.plugin.android.model.source.photopicker.PhotoItem;
import com.zoyi.channel.plugin.android.selector.StyleSelector;
import com.zoyi.channel.plugin.android.util.FormatUtils;
import com.zoyi.channel.plugin.android.util.draw.Resizer;
import com.zoyi.channel.plugin.android.view.external.smooth_checkbox.SmoothCheckBox;
import com.zoyi.com.bumptech.glide.Glide;
import com.zoyi.com.bumptech.glide.load.engine.DiskCacheStrategy;

class PhotoHolder
extends RecyclerView.ViewHolder
implements View.OnClickListener {
    private RelativeLayout root;
    private ImageView imageView;
    private SmoothCheckBox checkBox;
    private TextView textDuration;
    private int itemMargin;
    @Nullable
    private OnPhotoClickListener listener;
    @Nullable
    private PhotoItem photoItem;

    PhotoHolder(View itemView, int itemSize, int itemMargin, @Nullable OnPhotoClickListener listener) {
        super(itemView);
        this.itemMargin = itemMargin;
        this.listener = listener;
        this.root = (RelativeLayout)itemView.findViewById(R.id.ch_layoutPhotoPicker);
        this.imageView = (ImageView)itemView.findViewById(R.id.ch_imagePhotoPicker);
        this.checkBox = (SmoothCheckBox)itemView.findViewById(R.id.ch_checkboxPhotoPicker);
        this.textDuration = (TextView)itemView.findViewById(R.id.ch_textPhotoPickerItemDuration);
        this.checkBox.setOnClickListener(this);
        this.root.setOnClickListener((View.OnClickListener)this);
        this.checkBox.setVisibility(0);
        this.checkBox.setCheckedColor(StyleSelector.getBackColor());
        this.checkBox.setTickColor(StyleSelector.getTextColor());
        this.checkBox.setClickable(false);
        Resizer.size(itemView, itemSize, itemSize);
    }

    void setValue(PhotoItem photoItem, int position, boolean selected) {
        this.photoItem = photoItem;
        MarginBox marginBox = this.getMargin(position);
        this.root.setPadding(marginBox.getLeft(), marginBox.getTop(), marginBox.getRight(), marginBox.getBottom());
        this.checkBox.setChecked(selected);
        String formattedDuration = FormatUtils.formatDuration(photoItem.getDuration());
        if (formattedDuration != null && this.textDuration != null) {
            this.textDuration.setVisibility(0);
            this.textDuration.setText((CharSequence)formattedDuration);
        } else if (this.textDuration != null) {
            this.textDuration.setVisibility(8);
        }
        Glide.with((Context)this.itemView.getContext()).load(photoItem.getUri()).diskCacheStrategy(DiskCacheStrategy.RESULT).placeholder(R.drawable.ch_plugin_image_placeholder).error(R.drawable.ch_plugin_image_placeholder).into(this.imageView);
    }

    private MarginBox getMargin(int position) {
        if (position < 3) {
            return new MarginBox(this.itemMargin, this.itemMargin * 2, this.itemMargin, this.itemMargin * 2);
        }
        return new MarginBox(this.itemMargin, 0, this.itemMargin, this.itemMargin * 2);
    }

    private void checkboxClicked() {
        if (this.photoItem != null && this.listener != null) {
            this.listener.onPhotoClick(this.photoItem);
        }
    }

    public void onClick(View view) {
        int id2 = view.getId();
        if (id2 == R.id.ch_layoutPhotoPicker || id2 == R.id.checkbox) {
            this.checkboxClicked();
        }
    }
}

