/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chat.manager;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.zoyi.channel.plugin.android.action.ChatAction;
import com.zoyi.channel.plugin.android.activity.chat.listener.MessageSendListener;
import com.zoyi.channel.plugin.android.activity.chat.manager.ChatManagerInterface;
import com.zoyi.channel.plugin.android.activity.chat.model.DummyItem;
import com.zoyi.channel.plugin.android.activity.chat.model.SendActionItem;
import com.zoyi.channel.plugin.android.activity.chat.model.SendFileItem;
import com.zoyi.channel.plugin.android.activity.chat.model.SendItem;
import com.zoyi.channel.plugin.android.activity.chat.model.SendTextItem;
import com.zoyi.channel.plugin.android.activity.chat.type.ContentType;
import com.zoyi.channel.plugin.android.enumerate.SendingState;
import com.zoyi.channel.plugin.android.model.repo.MessageRepo;
import com.zoyi.channel.plugin.android.model.rest.ActionButton;
import com.zoyi.channel.plugin.android.network.RestSubscriber;
import com.zoyi.com.annimon.stream.Optional;
import com.zoyi.com.annimon.stream.Stream;
import com.zoyi.rx.Observable;
import com.zoyi.rx.Subscription;
import com.zoyi.rx.android.schedulers.AndroidSchedulers;
import com.zoyi.rx.functions.Action1;
import com.zoyi.rx.schedulers.Schedulers;
import com.zoyi.rx.subjects.PublishSubject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;

class RealChatManager
implements ChatManagerInterface {
    private String chatId;
    private Map<ContentType, Queue<SendItem>> queue;
    private Map<ContentType, SendItem> sendingItems;
    private PublishSubject<Integer> waitingCountPublishSubject = PublishSubject.create();
    private PublishSubject<Integer> uploadProgressPublishSubject = PublishSubject.create();
    @Nullable
    private Subscription fileSubscription;
    private int currentFileUploadProgress = 0;
    private Map<String, SendItem> failedItems;
    private boolean isReleased = false;
    @Nullable
    private MessageSendListener listener;

    RealChatManager(String chatId) {
        this.chatId = chatId;
        this.queue = new HashMap<ContentType, Queue<SendItem>>();
        this.sendingItems = new HashMap<ContentType, SendItem>();
        this.failedItems = new HashMap<String, SendItem>();
        for (ContentType contentType : ContentType.values()) {
            this.queue.put(contentType, new LinkedList());
        }
    }

    @Override
    public void attachListener(@Nullable MessageSendListener listener) {
        this.listener = listener;
    }

    @Override
    public void clearListener() {
        this.listener = null;
    }

    @Override
    public void sendMessage(SendItem item) {
        if (this.listener != null && item.shouldShowTempMessage()) {
            this.listener.onMessageItemUpsert(item);
        }
        if (item.getState() == SendingState.FAIL) {
            this.failedItems.put(item.getRequestId(), item);
        } else {
            this.enqueue(item.getContentType(), item);
        }
    }

    @Override
    public void sendMessages(List<SendItem> items) {
        Stream.ofNullable(items).forEach(this::sendMessage);
    }

    private void enqueue(ContentType contentType, SendItem item) {
        Optional.ofNullable(this.queue.get((Object)contentType)).ifPresent(q -> {
            q.add(item);
            if (contentType == ContentType.FILE) {
                this.notifyWaitingFileCount();
            }
            this.dequeue(contentType);
        });
    }

    private void dequeue(ContentType contentType) {
        if (!this.isReleased && this.sendingItems.get((Object)contentType) == null) {
            SendItem nextItem = (SendItem)Optional.ofNullable(this.queue.get((Object)contentType)).map(Queue::poll).orElse(null);
            switch (contentType) {
                case TEXT: {
                    if (!(nextItem instanceof SendTextItem)) break;
                    this.sendingItems.put(ContentType.TEXT, nextItem);
                    this.sendText((SendTextItem)nextItem);
                    break;
                }
                case FILE: {
                    if (nextItem instanceof SendFileItem) {
                        if (this.listener != null) {
                            this.listener.onMessageItemUpsert(nextItem);
                        }
                        this.sendingItems.put(ContentType.FILE, nextItem);
                        this.sendFile((SendFileItem)nextItem);
                        break;
                    }
                    if (nextItem != null || this.listener == null) break;
                    this.listener.onMessageItemRemove(DummyItem.createSendFileItem());
                    break;
                }
                case ACTION: {
                    if (!(nextItem instanceof SendActionItem)) break;
                    this.sendingItems.put(ContentType.ACTION, nextItem);
                    this.sendAction((SendActionItem)nextItem);
                }
            }
        }
    }

    private void sendText(SendTextItem item) {
        ChatAction.sendTextMessage(this.chatId, item, this.createCommonSubscriber(ContentType.TEXT, item));
    }

    private void sendFile(SendFileItem item) {
        this.fileSubscription = ChatAction.sendFileMessage(this.chatId, item, (Action1<Integer>)((Action1)this::updateFileUploadProgress), this.createCommonSubscriber(ContentType.FILE, item));
    }

    private void sendAction(SendActionItem item) {
        String actionType = item.getActionType();
        ActionButton actionButton = item.getActionButton();
        if (actionType != null && actionButton != null) {
            block5 : switch (actionType) {
                case "userChat.solve": 
                case "userChat.close": {
                    switch (actionButton.getKey()) {
                        case "close": {
                            this.closeChat(item);
                            break block5;
                        }
                        case "like": {
                            this.reviewChat(item, "like");
                            break block5;
                        }
                        case "dislike": {
                            this.reviewChat(item, "dislike");
                            break block5;
                        }
                    }
                    this.doAction(item);
                    break;
                }
                case "supportBot": {
                    this.selectSupportBotStep(item);
                    break;
                }
                default: {
                    this.doAction(item);
                }
            }
        }
    }

    private void closeChat(SendActionItem item) {
        ChatAction.closeChat(this.chatId, item, this.createCommonSubscriber(ContentType.ACTION, item));
    }

    private void reviewChat(SendActionItem item, @NonNull String review) {
        ChatAction.reviewChat(this.chatId, review, item, this.createCommonSubscriber(ContentType.ACTION, item));
    }

    private void selectSupportBotStep(SendActionItem item) {
        ChatAction.selectSupportBotStep(this.chatId, item, this.createCommonSubscriber(ContentType.ACTION, item));
    }

    private void doAction(SendActionItem item) {
        ChatAction.selectForm(this.chatId, item, this.createCommonSubscriber(ContentType.ACTION, item));
    }

    @Override
    public void resend(SendItem item) {
        this.remove(item);
        item.renew();
        this.sendMessage(item);
    }

    @Override
    public void remove(SendItem item) {
        if (this.listener != null) {
            this.listener.onMessageItemRemove(item);
        }
        this.failedItems.remove(item.getRequestId());
    }

    @Override
    public void cancelRecentSendingFile() {
        SendItem item = this.sendingItems.get((Object)ContentType.FILE);
        if (item != null && this.fileSubscription != null && !this.fileSubscription.isUnsubscribed()) {
            this.fileSubscription.unsubscribe();
            this.fileSubscription = null;
            this.sendingItems.remove((Object)ContentType.FILE);
            if (this.listener != null) {
                this.listener.onMessageItemRemove(item);
            }
            this.updateFileUploadProgress(0);
            this.dequeue(ContentType.FILE);
        }
    }

    @Override
    public int getWaitingFileCount() {
        return (Integer)Optional.ofNullable(this.queue.get((Object)ContentType.FILE)).map(Collection::size).orElse((Object)0);
    }

    @Override
    public int getCurrentFileUploadProgress() {
        return this.currentFileUploadProgress;
    }

    @Override
    @NonNull
    public List<SendItem> getUnsentItems() {
        ArrayList<SendItem> unsentItems = new ArrayList<SendItem>();
        for (ContentType contentType : ContentType.values()) {
            switch (contentType) {
                case TEXT: 
                case ACTION: {
                    Optional.ofNullable(this.queue.get((Object)contentType)).ifPresent(unsentItems::addAll);
                }
            }
        }
        Stream.ofNullable((Object[])ContentType.values()).filter(ContentType::isValid).map(type -> this.sendingItems.get(type)).forEach(item -> {
            if (item != null) {
                unsentItems.add((SendItem)item);
            }
        });
        unsentItems.addAll(this.failedItems.values());
        return unsentItems;
    }

    @Override
    public Observable<Integer> getUploadProgressObservable() {
        return this.uploadProgressPublishSubject.onBackpressureLatest().subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread());
    }

    @Override
    public Observable<Integer> getWaitingCountObservable() {
        return this.waitingCountPublishSubject.onBackpressureLatest().subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread());
    }

    private void notifyWaitingFileCount() {
        Optional.ofNullable(this.queue.get((Object)ContentType.FILE)).map(Collection::size).ifPresent(count -> this.waitingCountPublishSubject.onNext(count));
    }

    private RestSubscriber<MessageRepo> createCommonSubscriber(final ContentType contentType, final SendItem item) {
        return new RestSubscriber<MessageRepo>(){

            @Override
            public void onError(Throwable e) {
                item.doFail();
                RealChatManager.this.sendingItems.remove((Object)contentType);
                RealChatManager.this.failedItems.put(item.getRequestId(), item);
                if (RealChatManager.this.listener != null) {
                    RealChatManager.this.listener.onMessageItemUpsert(item);
                }
                RealChatManager.this.dequeue(contentType);
            }

            @Override
            public void onSuccess(@NonNull MessageRepo repo) {
                RealChatManager.this.sendingItems.remove((Object)contentType);
                if (RealChatManager.this.listener != null) {
                    RealChatManager.this.listener.onMessageItemRemove(item);
                    RealChatManager.this.listener.onMessageSendSuccess(repo.getMessage());
                }
                RealChatManager.this.dequeue(contentType);
            }
        };
    }

    private void updateFileUploadProgress(int progress) {
        this.currentFileUploadProgress = progress;
        this.uploadProgressPublishSubject.onNext((Object)progress);
    }

    @Override
    public void release() {
        this.isReleased = true;
        this.queue.clear();
        this.sendingItems.clear();
        this.failedItems.clear();
        this.listener = null;
    }
}

