package com.zoyi.channel.plugin.android.model.rest;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;

import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.model.entity.Entity;
import com.zoyi.channel.plugin.android.model.entity.ProfileEntity;
import com.zoyi.com.annimon.stream.Stream;

import java.util.List;

/**
 * Created by mika on 2016. 12. 6..
 */
public class Channel implements Entity, ProfileEntity {

  public static final String EXPECTED_RESPONSE_DELAY_INSTANT = "instant";
  public static final String EXPECTED_RESPONSE_DELAY_NORMAL = "normal";
  public static final String EXPECTED_RESPONSE_DELAY_DELAYED = "delayed";

  public static final String PLAN_PRO = "pro";

  private String id;
  private String name;
  @Nullable
  private String domain;
  @Nullable
  private String description;
  @Nullable
  private String timeZone;
  @Nullable
  private List<TimeRange> workingTimeRanges;
  @Nullable
  private String homepageUrl;
  @Nullable
  private String phoneNumber;
  @Nullable
  private String expectedResponseDelay;
  @Nullable
  private String workingType;
  @Nullable
  private String awayOption;
  @Nullable
  private String avatarUrl;
  @Nullable
  private String utcOffset;
  @Nullable
  private String defaultPluginId;
  @Nullable
  private Boolean whiteLabelFeature;

  @Override
  public String getId() {
    return id;
  }

  @NonNull
  @Override
  public String getName() {
    return name != null ? name : "";
  }

  @Nullable
  public String getDomain() {
    return domain;
  }

  @Nullable
  public String getDescription() {
    return description;
  }

  @Nullable
  public String getAwayOption() {
    return awayOption;
  }

  @Nullable
  public String getWorkingType() {
    return workingType;
  }

  @Nullable
  @Override
  public String getAvatarUrl() {
    return avatarUrl;
  }

  public final static String CLASSNAME = "channel";

  public String getWorkingTimeText() {
    if (workingTimeRanges != null) {
      String work = TextUtils.join(
          "\n",
          Stream.ofNullable(workingTimeRanges).map(TimeRange::getMessage).toList()
      );
      return String.format("%s\n\nTimezone: %s", work, timeZone);
    }
    return "";
  }

  @Nullable
  public List<TimeRange> getWorkingTimeRanges() {
    if (Const.WORKING_TYPE_CUSTOM.equals(workingType) && hasValidWorkingTime()) {
      return workingTimeRanges;
    }
    return null;
  }

  public boolean hasValidWorkingTime() {
    if (!Const.WORKING_TYPE_CUSTOM.equals(workingType)) {
      return false;
    }

    if (workingTimeRanges == null) {
      return false;
    }

    return Stream.ofNullable(workingTimeRanges)
        .filter(TimeRange::isValid)
        .count() > 0;
  }

  public long getUtcOffsetMinutes() {
    try {
      if (utcOffset != null) {
        String[] split = utcOffset.split(":");

        long hours = Long.valueOf(split[0]);
        long minutes = Long.valueOf(split[1]);
        int sign = hours < 0 ? -1 : 1;

        return (hours * sign * 60 + minutes) * sign;
      }
    } catch (Exception ignored) {
    }
    return 0;
  }

  @Nullable
  public String getHomepageUrl() {
    return homepageUrl;
  }

  @Nullable
  public String getPhoneNumber() {
    return phoneNumber;
  }

  @Nullable
  public String getExpectedResponseDelay() {
    return expectedResponseDelay;
  }

  @Nullable
  public String getDefaultPluginId() {
    return defaultPluginId;
  }

  public boolean isWhiteLabelFeature() {
    if (whiteLabelFeature == null) {
      return false;
    }
    return whiteLabelFeature;
  }
}
