package com.zoyi.channel.plugin.android.activity.chat.view.profilebot;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.FrameLayout;

import com.zoyi.channel.plugin.android.activity.chat.listener.OnProfileBotSubmitListener;
import com.zoyi.channel.plugin.android.enumerate.FetchState;
import com.zoyi.channel.plugin.android.store.ProfileBotStore;
import com.zoyi.channel.plugin.android.util.Initializer;

public abstract class BaseProfileBotInputView extends FrameLayout {

  public BaseProfileBotInputView(@NonNull Context context) {
    super(context);

    init(context);
  }

  public BaseProfileBotInputView(@NonNull Context context, @Nullable AttributeSet attrs) {
    super(context, attrs);

    init(context);
  }

  public BaseProfileBotInputView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
    super(context, attrs, defStyleAttr);

    init(context);
  }

  protected Context context;

  @Nullable
  private OnProfileBotSubmitListener listener;

  @Nullable
  private String key;

  @Nullable
  private FetchState fetchState;

  @Initializer
  private void init(Context context) {
    this.context = context;

    View root = LayoutInflater.from(context).inflate(getLayoutId(), this, true);

    initView(root);
  }

  protected void submit() {
    submit(getValue());
  }

  protected void submit(@Nullable Object value) {
    if (this.listener != null && this.key != null && this.fetchState != FetchState.LOADING) {
      this.listener.onSubmit(this.key, value);
    }
  }

  public void setValue(String key, @Nullable Object value, FetchState fetchState) {
    this.key = key;
    this.fetchState = fetchState;

    restore(value, fetchState);
  }

  public void setListener(OnProfileBotSubmitListener listener) {
    this.listener = listener;
  }

  // abstract functions

  protected abstract void initView(View root);

  @Nullable
  protected abstract Object getValue();

  protected abstract void restore(@Nullable Object value, FetchState fetchState);

  public abstract void focus();

  protected abstract int getLayoutId();

  public void onRecycled() {
    if (this.key != null) {
      ProfileBotStore.get().inputKey.set(this.key);
      ProfileBotStore.get().inputValue.set(getValue());
    }
  }
}
