/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.view.button;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.view.button.ThemeEffectiveView;
import com.zoyi.channel.plugin.android.view.layout.MaskableFrameLayout;

public class MaskImageButton
extends FrameLayout
implements View.OnTouchListener,
ThemeEffectiveView {
    private Context context;
    private MaskableFrameLayout mask;
    private View colorView;
    @Nullable
    private View.OnClickListener listener;
    @Nullable
    private Drawable image;
    private int color;

    public MaskImageButton(Context context) {
        super(context);
        this.init(context, null);
    }

    public MaskImageButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public MaskImageButton(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context, attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Initializer
    private void init(Context context, @Nullable AttributeSet attrs) {
        this.context = context;
        View view = LayoutInflater.from((Context)context).inflate(R.layout.ch_plugin_view_mask_image_button, (ViewGroup)this, true);
        this.mask = (MaskableFrameLayout)view.findViewById(R.id.ch_layoutMaskImageButtonMask);
        this.colorView = view.findViewById(R.id.ch_viewMaskImageButtonColor);
        if (attrs != null) {
            TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.MaskImageButton, 0, 0);
            try {
                this.image = typedArray.getDrawable(R.styleable.MaskImageButton_ch_mib_image);
                this.color = typedArray.getColor(R.styleable.MaskImageButton_ch_mib_color, -1);
            }
            finally {
                typedArray.recycle();
            }
        }
        this.apply();
    }

    public void setOnClickListener(@Nullable View.OnClickListener l) {
        this.listener = l;
        super.setOnClickListener(v -> {
            if (v.isEnabled() && this.listener != null) {
                this.listener.onClick(v);
            }
        });
        this.setOnTouchListener(this);
    }

    public void setMask(int resId) {
        this.image = ContextCompat.getDrawable((Context)this.context, (int)resId);
        this.apply();
    }

    public void setColor(int color2) {
        this.color = color2;
        this.apply();
    }

    private void apply() {
        if (this.image != null) {
            this.mask.setMask(this.image);
        }
        this.colorView.setBackgroundColor(this.color);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (enabled) {
            this.colorView.setAlpha(1.0f);
        } else {
            this.colorView.setAlpha(0.3f);
        }
    }

    public boolean onTouch(View v, MotionEvent event) {
        if (v.isEnabled()) {
            switch (event.getAction()) {
                case 0: {
                    this.colorView.setAlpha(0.3f);
                    break;
                }
                case 1: 
                case 3: {
                    this.colorView.setAlpha(1.0f);
                }
            }
        }
        return false;
    }

    @Override
    public void onThemeChange(int backColor, int textColor) {
        this.setColor(textColor);
    }
}

