/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.util;

import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.TimeUtils;
import com.zoyi.com.google.i18n.phonenumbers.PhoneNumberUtil;
import com.zoyi.com.google.i18n.phonenumbers.Phonenumber;
import java.math.BigDecimal;
import java.util.Locale;

public class FormatUtils {
    @Nullable
    public static String formatDuration(@Nullable Long durationMilliseconds) {
        if (durationMilliseconds == null || durationMilliseconds == 0L) {
            return null;
        }
        long durationSeconds = durationMilliseconds / 1000L;
        long hours = durationSeconds / 3600L;
        long minutes = durationSeconds % 3600L / 60L;
        long seconds = durationSeconds % 60L;
        if (hours > 0L) {
            return String.format(Locale.ENGLISH, "%d:%02d:%02d", hours, minutes, seconds);
        }
        return String.format(Locale.ENGLISH, "%d:%02d", minutes, seconds);
    }

    public static String formatFileSize(long bytes) {
        if (bytes < 1000L) {
            return String.format(Locale.US, "%dB", bytes);
        }
        if (bytes <= 1000000L) {
            return String.format(Locale.US, "%.1fKB", (double)bytes / 1000.0);
        }
        if (bytes <= 1000000000L) {
            return String.format(Locale.US, "%.1fMB", (double)bytes / 1000000.0);
        }
        return String.format(Locale.US, "%.1fGB", (double)bytes / 1.0E9);
    }

    public static String formatUserProfile(String key, String type, @Nullable Object value) {
        String datetimeFormat;
        if ("mobileNumber".equals(key) && value instanceof String) {
            PhoneNumberUtil phoneUtil = PhoneNumberUtil.getInstance();
            try {
                Phonenumber.PhoneNumber numberProto = phoneUtil.parse((CharSequence)value.toString(), "");
                return phoneUtil.format(numberProto, PhoneNumberUtil.PhoneNumberFormat.INTERNATIONAL);
            }
            catch (Exception numberProto) {
                // empty catch block
            }
        }
        if ("date".equals(type) && value instanceof Long && !TextUtils.isEmpty((CharSequence)(datetimeFormat = TimeUtils.formatDatetime((Long)value)))) {
            return datetimeFormat;
        }
        if ("boolean".equals(type) && value instanceof Boolean) {
            if (((Boolean)value).booleanValue()) {
                return ResUtils.getString("ch.profile_form.boolean.yes");
            }
            return ResUtils.getString("ch.profile_form.boolean.no");
        }
        if (value == null) {
            return "";
        }
        if (value instanceof Double) {
            BigDecimal bigDecimal = new BigDecimal(value.toString());
            String numberValue = bigDecimal.toString();
            if (numberValue.endsWith(".0")) {
                return numberValue.replace(".0", "");
            }
            return numberValue;
        }
        return value.toString();
    }
}

