/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.util;

import android.content.Context;
import android.support.annotation.Nullable;
import com.zoyi.channel.plugin.android.activity.base.BaseActivity2;
import com.zoyi.channel.plugin.android.model.rest.Channel;
import com.zoyi.channel.plugin.android.model.rest.TimeRange;
import com.zoyi.com.annimon.stream.Stream;
import java.util.Calendar;
import java.util.SimpleTimeZone;

public class ChannelUtils {
    private static final long MINUTES_TO_MILLISECONDS = 60000L;
    private static final int WEEK_COUNT = 7;
    private static final int DAY_IN_MINUTES = 1440;
    private static final int WEEK_IN_MINUTES = 10080;

    public static boolean isChannelPluginActivity(Context context) {
        return context instanceof BaseActivity2;
    }

    public static boolean isWorking(@Nullable Channel channel, @Nullable Long timestamp) {
        return ChannelUtils.getMinutesLeftToWork(channel, timestamp) == 0;
    }

    public static int getMinutesLeftToWork(@Nullable Channel channel, @Nullable Long timestamp) {
        if (channel == null || timestamp == null || timestamp == 0L) {
            return -1;
        }
        if ("always".equals(channel.getWorkingType())) {
            return 0;
        }
        if ("never".equals(channel.getWorkingType())) {
            return -1;
        }
        if (!channel.hasValidWorkingTime()) {
            return 0;
        }
        long utcOffsetMilliseconds = channel.getUtcOffsetMinutes() * 60000L;
        long now = timestamp + utcOffsetMilliseconds;
        Calendar calendar = Calendar.getInstance(new SimpleTimeZone(0, "UTC"));
        calendar.setTimeInMillis(now);
        int todayWeekday = (calendar.get(7) + 5) % 7;
        int hours = calendar.get(11);
        int minutes = calendar.get(12);
        int nowMinutes = hours * 60 + minutes;
        return (Integer)Stream.ofNullable(channel.getWorkingTimeRanges()).map(timeRange -> ChannelUtils.getRemainingMinuteForTimeRange(timeRange, todayWeekday, nowMinutes)).min(Integer::compareTo).map(it -> it == Integer.MAX_VALUE ? -1 : it).orElse((Object)-1);
    }

    private static int getRemainingMinuteForTimeRange(TimeRange timeRange, int nowWeekDay, int nowMinutes) {
        return (Integer)Stream.ofNullable(timeRange.getDayOfWeeks()).map(weekDay -> {
            int weekDayDiff = (weekDay.getIndex() - nowWeekDay + 7) % 7;
            if (weekDayDiff == 0 && timeRange.getFrom() <= nowMinutes && nowMinutes <= timeRange.getTo()) {
                return 0;
            }
            return (weekDayDiff * 1440 + timeRange.getFrom() - nowMinutes + 10080) % 10080;
        }).min(Integer::compareTo).orElse((Object)Integer.MAX_VALUE);
    }
}

