/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.language;

import android.app.Dialog;
import android.content.Context;
import android.support.annotation.Nullable;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.base.BaseActivity2;
import com.zoyi.channel.plugin.android.activity.language.LanguageSettingsPresenter;
import com.zoyi.channel.plugin.android.activity.language.contract.LanguageSettingsContract;
import com.zoyi.channel.plugin.android.open.option.Language;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.util.ProgressHelper;
import com.zoyi.channel.plugin.android.util.ResUtils;

public class LanguageSettingsActivity
extends BaseActivity2
implements LanguageSettingsContract.View {
    private LanguageSettingsContract.Presenter presenter;
    @Nullable
    private Dialog dialog;

    @Override
    @Initializer
    protected boolean onCreate() {
        this.init(R.layout.ch_plugin_activity_language_settings);
        this.findViewById(R.id.ch_textOptionLanguageKo).setOnClickListener(v -> this.changeLanguage(Language.KOREAN));
        this.findViewById(R.id.ch_textOptionLanguageJa).setOnClickListener(v -> this.changeLanguage(Language.JAPANESE));
        this.findViewById(R.id.ch_textOptionLanguageEn).setOnClickListener(v -> this.changeLanguage(Language.ENGLISH));
        this.presenter = new LanguageSettingsPresenter(this);
        this.bindPresenter(this.presenter);
        return true;
    }

    private void changeLanguage(Language language) {
        this.presenter.changeLanguage(language);
    }

    @Override
    public void showProgress(Language language) {
        this.hideProgress();
        this.dialog = ProgressHelper.show((Context)this, ResUtils.getString((Context)this, language, "ch.settings.changing_message"), false);
    }

    @Override
    public void hideProgress() {
        if (this.dialog != null && this.dialog.isShowing()) {
            this.dialog.dismiss();
            this.dialog = null;
        }
    }

    @Override
    public void onLanguageChange(Language language) {
        this.finish();
    }
}

