/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chat.viewholder;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnMessageContentClickListener;
import com.zoyi.channel.plugin.android.activity.chat.manager.ChatManager;
import com.zoyi.channel.plugin.android.activity.chat.model.SendFileItem;
import com.zoyi.channel.plugin.android.base.adapter.BaseViewHolder;
import com.zoyi.channel.plugin.android.enumerate.SendingState;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.com.bumptech.glide.Glide;
import com.zoyi.com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.zoyi.rx.Subscription;
import java.util.Locale;

public class UploadStateHolder
extends BaseViewHolder {
    private ImageView imageThumbnail;
    private TextView textFileName;
    private ImageView imageCancel;
    private ImageView imageRetry;
    private TextView textFileQueue;
    private ProgressBar progressBar;
    @Nullable
    private Subscription progressSubscription;
    @Nullable
    private Subscription waitingCountSubscription;
    @Nullable
    private SendFileItem fileItem;

    private UploadStateHolder(@NonNull View itemView, @Nullable OnMessageContentClickListener onMessageContentClickListener) {
        super(itemView);
        this.imageThumbnail = (ImageView)itemView.findViewById(R.id.ch_imageFileUploadThumbnail);
        this.textFileName = (TextView)itemView.findViewById(R.id.ch_textFileUploadFileName);
        this.imageCancel = (ImageView)itemView.findViewById(R.id.ch_buttonFileUploadCancel);
        this.imageRetry = (ImageView)itemView.findViewById(R.id.ch_buttonFileUploadRetry);
        this.textFileQueue = (TextView)itemView.findViewById(R.id.ch_textFileUploadWaitingQueue);
        this.progressBar = (ProgressBar)itemView.findViewById(R.id.ch_progressFileUpload);
        this.imageCancel.setOnClickListener(view -> {
            if (onMessageContentClickListener != null) {
                onMessageContentClickListener.onCancelClick(this.fileItem);
            }
        });
        this.imageRetry.setOnClickListener(view -> {
            if (onMessageContentClickListener != null && this.fileItem != null) {
                onMessageContentClickListener.onResendButtonClick(this.fileItem);
            }
        });
    }

    public void bind(SendFileItem fileItem) {
        this.clear();
        this.fileItem = fileItem;
        this.textFileName.setText((CharSequence)fileItem.getName());
        Glide.with((Context)this.itemView.getContext()).load(fileItem.getUri()).diskCacheStrategy(DiskCacheStrategy.RESULT).placeholder(R.drawable.ch_plugin_image_placeholder).error(R.drawable.ch_plugin_image_placeholder).centerCrop().into(this.imageThumbnail);
        if (fileItem.getState() == SendingState.FAIL) {
            this.imageRetry.setVisibility(0);
            this.textFileQueue.setVisibility(8);
            this.progressBar.setVisibility(8);
        } else {
            this.imageRetry.setVisibility(8);
            this.progressBar.setVisibility(0);
            this.progressBar.setProgress(ChatManager.get(fileItem.getChatId()).getCurrentFileUploadProgress());
            this.progressSubscription = ChatManager.get(fileItem.getChatId()).getUploadProgressObservable().subscribe(progress -> this.progressBar.setProgress(progress.intValue()));
            this.setWaitingCount(ChatManager.get(fileItem.getChatId()).getWaitingFileCount());
            this.waitingCountSubscription = ChatManager.get(fileItem.getChatId()).getWaitingCountObservable().subscribe(this::setWaitingCount);
        }
    }

    private void setWaitingCount(int waitingCount) {
        if (waitingCount == 0) {
            this.textFileQueue.setVisibility(8);
        } else {
            this.textFileQueue.setVisibility(0);
            this.textFileQueue.setText((CharSequence)String.format(Locale.getDefault(), ResUtils.getString(this.itemView.getContext(), "ch.file_upload.wait_count"), waitingCount));
        }
    }

    @Override
    protected void clear() {
        this.fileItem = null;
        this.progressBar.setProgress(0);
        if (this.progressSubscription != null && !this.progressSubscription.isUnsubscribed()) {
            this.progressSubscription.unsubscribe();
            this.progressSubscription = null;
        }
        if (this.waitingCountSubscription != null && !this.waitingCountSubscription.isUnsubscribed()) {
            this.waitingCountSubscription.unsubscribe();
            this.waitingCountSubscription = null;
        }
        if (this.imageThumbnail != null) {
            Glide.clear((View)this.imageThumbnail);
        }
    }

    public static UploadStateHolder newInstance(ViewGroup parent, @Nullable OnMessageContentClickListener onMessageContentClickListener) {
        return new UploadStateHolder(LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.ch_plugin_item_upload_state, parent, false), onMessageContentClickListener);
    }
}

