/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chat;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.util.SortedList;
import android.view.ViewGroup;
import com.zoyi.channel.plugin.android.activity.base.SortedListCallback;
import com.zoyi.channel.plugin.android.activity.chat.contract.ChatAdapterContract;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnChatActionListener;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnMessageContentClickListener;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnProfileUpdateRequestListener;
import com.zoyi.channel.plugin.android.activity.chat.model.ChatMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.model.DummyItem;
import com.zoyi.channel.plugin.android.activity.chat.model.InitMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.model.LogMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.model.MessageItem;
import com.zoyi.channel.plugin.android.activity.chat.model.NewMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.model.ProfileBotMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.model.SendActionItem;
import com.zoyi.channel.plugin.android.activity.chat.model.SendFileItem;
import com.zoyi.channel.plugin.android.activity.chat.model.SendItem;
import com.zoyi.channel.plugin.android.activity.chat.model.SendTextItem;
import com.zoyi.channel.plugin.android.activity.chat.model.SupportBotMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.model.TypingItem;
import com.zoyi.channel.plugin.android.activity.chat.model.WelcomeMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.type.MessageType;
import com.zoyi.channel.plugin.android.activity.chat.viewholder.HostMessageHolder;
import com.zoyi.channel.plugin.android.activity.chat.viewholder.LogMessageHolder;
import com.zoyi.channel.plugin.android.activity.chat.viewholder.NewMessageHolder;
import com.zoyi.channel.plugin.android.activity.chat.viewholder.ProfileBotMessageHolder;
import com.zoyi.channel.plugin.android.activity.chat.viewholder.SendingActionMessageHolder;
import com.zoyi.channel.plugin.android.activity.chat.viewholder.SendingTextMessageHolder;
import com.zoyi.channel.plugin.android.activity.chat.viewholder.SupportBotMessageHolder;
import com.zoyi.channel.plugin.android.activity.chat.viewholder.TypingHolder;
import com.zoyi.channel.plugin.android.activity.chat.viewholder.UploadStateHolder;
import com.zoyi.channel.plugin.android.activity.chat.viewholder.UserMessageHolder;
import com.zoyi.channel.plugin.android.activity.chat.viewholder.WelcomeMessageHolder;
import com.zoyi.channel.plugin.android.base.adapter.BaseAdapter;
import com.zoyi.channel.plugin.android.base.adapter.BaseViewHolder;
import com.zoyi.channel.plugin.android.model.etc.Typing;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.model.rest.Session;
import com.zoyi.channel.plugin.android.util.CompareUtils;
import com.zoyi.com.annimon.stream.Stream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class ChatAdapter
extends BaseAdapter<BaseViewHolder>
implements ChatAdapterContract.View,
ChatAdapterContract.Model {
    private SortedList<MessageItem> items;
    @Nullable
    private OnProfileUpdateRequestListener onProfileUpdateRequestListener;
    @Nullable
    private OnMessageContentClickListener onMessageContentClickListener;
    @Nullable
    private OnChatActionListener listener;
    @NonNull
    private TypingItem typingItem;
    @Nullable
    private InitMessageItem initMessageItem = null;
    @Nullable
    private String backwardId = null;

    public ChatAdapter(@Nullable OnChatActionListener listener) {
        this.listener = listener;
        this.items = new SortedList(MessageItem.class, new SortedListCallback(this, false));
        this.typingItem = new TypingItem();
        this.items.add((Object)this.typingItem);
    }

    public void setOnProfileUpdateRequestListener(@Nullable OnProfileUpdateRequestListener onProfileUpdateRequestListener) {
        this.onProfileUpdateRequestListener = onProfileUpdateRequestListener;
    }

    public void setOnMessageContentClickListener(@Nullable OnMessageContentClickListener onMessageContentClickListener) {
        this.onMessageContentClickListener = onMessageContentClickListener;
    }

    @Override
    public void setInitMessage(InitMessageItem item) {
        if (item != null && this.initMessageItem == null) {
            this.initMessageItem = item;
            this.items.add((Object)item);
        }
    }

    @Override
    public void setMessages(Collection<Message> messages, Collection<SendItem> unsentItems, @Nullable Session lastReadSession, @Nullable String backwardId) {
        this.backwardId = backwardId;
        List<MessageItem> newItems = this.purifyMessages(messages, lastReadSession);
        newItems.add(this.typingItem);
        newItems.addAll(unsentItems);
        this.items.replaceAll(newItems);
    }

    @Override
    public void replaceInitMessageItem(Message message) {
        if (this.initMessageItem != null) {
            this.items.remove((Object)this.initMessageItem);
        }
        if (message != null) {
            this.addMessages(Collections.singleton(message), null, null);
        }
    }

    @Override
    public void addMessages(Collection<Message> messages, @Nullable Session lastReadSession, @Nullable String backwardId) {
        this.backwardId = backwardId;
        this.addMessages(messages, lastReadSession);
    }

    private void addMessages(Collection<Message> messages, @Nullable Session lastReadSession) {
        List<MessageItem> newItems = this.purifyMessages(messages, lastReadSession);
        this.items.beginBatchedUpdates();
        for (MessageItem item : newItems) {
            this.items.add((Object)item);
        }
        for (Message message : messages) {
            DummyItem item;
            if (message == null || !CompareUtils.exists((Comparable)((Object)message.getPersonType()), (Comparable[])new String[]{"user"}) || (item = DummyItem.createItem(message.getRequestId())) == null) continue;
            this.items.remove((Object)item);
        }
        this.items.endBatchedUpdates();
    }

    @Override
    public void addMessage(Message message) {
        this.addMessages(Collections.singleton(message), null);
    }

    @NonNull
    private List<MessageItem> purifyMessages(Collection<Message> messages, @Nullable Session session) {
        ArrayList<MessageItem> newItems = new ArrayList<MessageItem>();
        long minTimestamp = Long.MAX_VALUE;
        long maxTimestamp = Long.MIN_VALUE;
        for (Message message : messages) {
            if (message == null) continue;
            minTimestamp = Math.min(minTimestamp, message.getCreatedAt());
            maxTimestamp = Math.max(maxTimestamp, message.getCreatedAt());
            if (message.getLog() != null) continue;
            newItems.add(new ChatMessageItem(message));
            if (message.getProfileBot() == null) continue;
            newItems.add(new ProfileBotMessageItem(message));
        }
        if (session != null && session.getReadAt() != null && minTimestamp < session.getReadAt() && session.getReadAt() < maxTimestamp) {
            newItems.add(new NewMessageItem(session.getReadAt()));
        }
        return newItems;
    }

    @Override
    public void addMessageItem(MessageItem item) {
        this.items.add((Object)item);
    }

    @Override
    public void addMessageItems(Collection<? extends MessageItem> items) {
        this.items.addAll((Collection)Stream.ofNullable(items).map(it -> it).toList());
    }

    @Override
    public void removeMessageItem(MessageItem item) {
        this.items.remove((Object)item);
    }

    @Override
    public void setTypings(List<Typing> typings) {
        this.addMessageItem(this.typingItem.setTypings(typings));
    }

    @Nullable
    public BaseViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        MessageType type = MessageType.fromId(viewType);
        switch (type) {
            case NEW_MESSAGE_DIVIDER: {
                return NewMessageHolder.newInstance(parent);
            }
            case TYPING: {
                return TypingHolder.newInstance(parent);
            }
            case LOG: {
                return LogMessageHolder.newInstance(parent);
            }
            case SENDING: {
                return SendingTextMessageHolder.newInstance(parent, this.listener);
            }
            case SENDING_ACTION: {
                return SendingActionMessageHolder.newInstance(parent, this.listener);
            }
            case HOST: {
                return HostMessageHolder.newInstance(parent, this.listener);
            }
            case USER: {
                return UserMessageHolder.newInstance(parent, this.listener);
            }
            case PROFILE_BOT: {
                return ProfileBotMessageHolder.newInstance(parent, this.onProfileUpdateRequestListener);
            }
            case WELCOME: {
                return WelcomeMessageHolder.newInstance(parent, this.listener);
            }
            case SUPPORT_BOT: {
                return SupportBotMessageHolder.newInstance(parent, this.listener);
            }
            case FAILED_FILE: 
            case SENDING_FILE: {
                return UploadStateHolder.newInstance(parent, this.onMessageContentClickListener);
            }
        }
        return null;
    }

    public void onBindViewHolder(BaseViewHolder holder, int position) {
        MessageItem item = (MessageItem)this.items.get(position);
        switch (item.getType()) {
            case TYPING: {
                TypingHolder typingHolder = (TypingHolder)holder;
                typingHolder.bind((TypingItem)item);
                break;
            }
            case LOG: {
                LogMessageHolder logMessageHolder = (LogMessageHolder)holder;
                logMessageHolder.bind((LogMessageItem)item);
                break;
            }
            case SENDING: {
                SendTextItem textItem = (SendTextItem)item;
                SendingTextMessageHolder sendingTextHolder = (SendingTextMessageHolder)holder;
                sendingTextHolder.bind(textItem, !textItem.isConnected(this.getItem(position + 1)));
                break;
            }
            case SENDING_ACTION: {
                SendActionItem actionItem = (SendActionItem)item;
                SendingActionMessageHolder sendingActionHolder = (SendingActionMessageHolder)holder;
                sendingActionHolder.bind(actionItem);
                break;
            }
            case HOST: {
                ChatMessageItem chatMessageItem = (ChatMessageItem)item;
                HostMessageHolder hostMessageHolder = (HostMessageHolder)holder;
                boolean isHead = chatMessageItem.getMessage().hasContents() ? !chatMessageItem.isConnected(this.getItem(position - 1)) : !chatMessageItem.isSamePerson(this.getItem(position - 1)) && this.isLastPosition(position);
                hostMessageHolder.bind(chatMessageItem, !chatMessageItem.isSameDate(this.getItem(position - 1)) || this.isFirstMessage(position), isHead, !chatMessageItem.isConnected(this.getItem(position + 1)), this.isLastPosition(position));
                break;
            }
            case USER: {
                ChatMessageItem chatMessageItem = (ChatMessageItem)item;
                UserMessageHolder userMessageHolder = (UserMessageHolder)holder;
                userMessageHolder.bind(chatMessageItem, !chatMessageItem.isSameDate(this.getItem(position - 1)) || this.isFirstMessage(position), !chatMessageItem.isConnected(this.getItem(position - 1)), !chatMessageItem.isConnected(this.getItem(position + 1)));
                break;
            }
            case PROFILE_BOT: {
                ProfileBotMessageItem profileItem = (ProfileBotMessageItem)item;
                ProfileBotMessageHolder profileBotMessageHolder = (ProfileBotMessageHolder)holder;
                profileBotMessageHolder.bind(profileItem);
                break;
            }
            case WELCOME: {
                WelcomeMessageItem welcomeMessageItem = (WelcomeMessageItem)item;
                WelcomeMessageHolder welcomeMessageHolder = (WelcomeMessageHolder)holder;
                welcomeMessageHolder.bind(welcomeMessageItem);
                break;
            }
            case SUPPORT_BOT: {
                SupportBotMessageItem supportBotMessageItem = (SupportBotMessageItem)item;
                SupportBotMessageHolder supportBotMessageHolder = (SupportBotMessageHolder)holder;
                supportBotMessageHolder.bind(supportBotMessageItem, this.isLastPosition(position));
                break;
            }
            case FAILED_FILE: 
            case SENDING_FILE: {
                SendFileItem sendFileItem = (SendFileItem)item;
                UploadStateHolder uploadStateHolder = (UploadStateHolder)holder;
                uploadStateHolder.bind(sendFileItem);
            }
        }
    }

    @Nullable
    private MessageItem getItem(int position) {
        if (position >= 0 && position < this.items.size()) {
            return (MessageItem)this.items.get(position);
        }
        return null;
    }

    private boolean isLastPosition(int position) {
        MessageItem item = this.getItem(position + 1);
        return item == null || item.getPrimaryKey() != null && item.getPrimaryKey() > 9223372036854774807L;
    }

    private boolean isFirstMessage(int position) {
        return position == 0 && this.backwardId == null;
    }

    public int getItemViewType(int position) {
        return ((MessageItem)this.items.get(position)).getType().toInt();
    }

    public int getItemCount() {
        return this.items.size();
    }
}

