/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.subscriptions;

import com.zoyi.rx.Subscription;
import com.zoyi.rx.subscriptions.Subscriptions;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public final class RefCountSubscription
implements Subscription {
    private final Subscription actual;
    static final State EMPTY_STATE = new State(false, 0);
    final AtomicReference<State> state = new AtomicReference<State>(EMPTY_STATE);

    public RefCountSubscription(Subscription s) {
        if (s == null) {
            throw new IllegalArgumentException("s");
        }
        this.actual = s;
    }

    public Subscription get() {
        State newState;
        State oldState;
        AtomicReference<State> localState = this.state;
        do {
            oldState = localState.get();
            if (!oldState.isUnsubscribed) continue;
            return Subscriptions.unsubscribed();
        } while (!localState.compareAndSet(oldState, newState = oldState.addChild()));
        return new InnerSubscription(this);
    }

    public boolean isUnsubscribed() {
        return this.state.get().isUnsubscribed;
    }

    public void unsubscribe() {
        State newState;
        State oldState;
        AtomicReference<State> localState = this.state;
        do {
            oldState = localState.get();
            if (!oldState.isUnsubscribed) continue;
            return;
        } while (!localState.compareAndSet(oldState, newState = oldState.unsubscribe()));
        this.unsubscribeActualIfApplicable(newState);
    }

    private void unsubscribeActualIfApplicable(State state) {
        if (state.isUnsubscribed && state.children == 0) {
            this.actual.unsubscribe();
        }
    }

    void unsubscribeAChild() {
        State newState;
        State oldState;
        AtomicReference<State> localState = this.state;
        while (!localState.compareAndSet(oldState = localState.get(), newState = oldState.removeChild())) {
        }
        this.unsubscribeActualIfApplicable(newState);
    }

    static final class InnerSubscription
    extends AtomicInteger
    implements Subscription {
        private static final long serialVersionUID = 7005765588239987643L;
        final RefCountSubscription parent;

        public InnerSubscription(RefCountSubscription parent) {
            this.parent = parent;
        }

        public void unsubscribe() {
            if (this.compareAndSet(0, 1)) {
                this.parent.unsubscribeAChild();
            }
        }

        public boolean isUnsubscribed() {
            return this.get() != 0;
        }
    }

    static final class State {
        final boolean isUnsubscribed;
        final int children;

        State(boolean u, int c) {
            this.isUnsubscribed = u;
            this.children = c;
        }

        State addChild() {
            return new State(this.isUnsubscribed, this.children + 1);
        }

        State removeChild() {
            return new State(this.isUnsubscribed, this.children - 1);
        }

        State unsubscribe() {
            return new State(true, this.children);
        }
    }
}

