package com.zoyi.channel.plugin.android.view.button;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.widget.FrameLayout;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.view.layout.MaskableFrameLayout;

public class MaskImageButton extends FrameLayout implements View.OnTouchListener, ThemeEffectiveView {

  private Context context;

  private MaskableFrameLayout mask;
  private View colorView;

  @Nullable
  private OnClickListener listener;

  @Nullable
  private Drawable image;
  private int color;

  public MaskImageButton(Context context) {
    super(context);
    init(context, null);
  }

  public MaskImageButton(Context context, AttributeSet attrs) {
    super(context, attrs);
    init(context, attrs);
  }

  public MaskImageButton(Context context, AttributeSet attrs, int defStyle) {
    super(context, attrs, defStyle);
    init(context, attrs);
  }

  @Initializer
  private void init(Context context, @Nullable AttributeSet attrs) {
    this.context = context;

    View view = LayoutInflater.from(context).inflate(R.layout.ch_plugin_view_mask_image_button, this, true);

    mask = view.findViewById(R.id.ch_layoutMaskImageButtonMask);
    colorView = view.findViewById(R.id.ch_viewMaskImageButtonColor);

    if (attrs != null) {
      TypedArray typedArray = context.getTheme().obtainStyledAttributes(
          attrs,
          R.styleable.MaskImageButton,
          0,
          0
      );

      try {
        image = typedArray.getDrawable(R.styleable.MaskImageButton_ch_mib_image);
        color = typedArray.getColor(R.styleable.MaskImageButton_ch_mib_color, Color.WHITE);
      } finally {
        typedArray.recycle();
      }
    }

    apply();
  }

  @Override
  public void setOnClickListener(@Nullable View.OnClickListener l) {
    this.listener = l;

    super.setOnClickListener(v -> {
      if (v.isEnabled() && listener != null) {
        listener.onClick(v);
      }
    });

    setOnTouchListener(this);
  }

  public void setMask(int resId) {
    this.image = ContextCompat.getDrawable(context, resId);

    apply();
  }

  public void setColor(int color) {
    this.color = color;

    apply();
  }

  private void apply() {
    if (image != null) {
      mask.setMask(image);
    }
    colorView.setBackgroundColor(color);
  }

  @Override
  public void setEnabled(boolean enabled) {
    super.setEnabled(enabled);

    if (enabled) {
      colorView.setAlpha(1.0f);
    } else {
      colorView.setAlpha(0.3f);
    }
  }

  @Override
  public boolean onTouch(View v, MotionEvent event) {
    if (v.isEnabled()) {
      switch (event.getAction()) {
        case MotionEvent.ACTION_DOWN:
          colorView.setAlpha(0.3f);
          break;

        case MotionEvent.ACTION_UP:
        case MotionEvent.ACTION_CANCEL:
          colorView.setAlpha(1.0f);
          break;
      }
    }
    return false;
  }

  @Override
  public void onThemeChange(int backColor, int textColor) {
    setColor(textColor);
  }
}
