package com.zoyi.channel.plugin.android.activity.chat.viewholder;

import android.view.View;
import android.widget.TextView;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.base.adapter.BaseViewHolder;
import com.zoyi.channel.plugin.android.store.SettingsStore;
import com.zoyi.channel.plugin.android.util.TimeUtils;
import com.zoyi.channel.plugin.android.util.Views;

public abstract class AbsMessageHolder extends BaseViewHolder {

  private final static Long cutOff = 24L * 60L * 60L * 1000L;

  private View viewHead;
  private View viewTail;

  private TextView textDate;
  private TextView textCreatedAt;

  AbsMessageHolder(View itemView) {
    super(itemView);

    viewHead = itemView.findViewById(R.id.ch_layoutMessageHolderHead);
    viewTail = itemView.findViewById(R.id.ch_viewMessageHolderTailPadding);

    textDate = itemView.findViewById(R.id.ch_textMessageHolderDate);
    textCreatedAt = itemView.findViewById(R.id.ch_textMessageHolderTime);
  }

  public void bind(Long createdAt, boolean showDate, boolean isHead, boolean isTail) {
    Views.setVisibility(viewHead, isHead);
    Views.setVisibility(viewTail, isTail);

    textCreatedAt.setText(TimeUtils.getTime(createdAt));

    if (textDate != null && showDate && createdAt != null) {
      textDate.setVisibility(View.VISIBLE);
      textDate.setText(TimeUtils.formatTranslatedDate(createdAt, SettingsStore.get().language.get()));
    } else if (textDate != null) {
      textDate.setVisibility(View.GONE);
    }
  }
}
