/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.view.youtube.ui;

import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.util.L;
import com.zoyi.channel.plugin.android.view.external.cpv.CircularProgressView;
import com.zoyi.channel.plugin.android.view.youtube.player.PlayerConstants;
import com.zoyi.channel.plugin.android.view.youtube.player.YouTubePlayer;
import com.zoyi.channel.plugin.android.view.youtube.player.listener.YouTubePlayerFullScreenListener;
import com.zoyi.channel.plugin.android.view.youtube.player.listener.YouTubePlayerListener;
import com.zoyi.channel.plugin.android.view.youtube.player.views.LegacyYouTubePlayerView;
import com.zoyi.channel.plugin.android.view.youtube.ui.PlayerUiController;
import com.zoyi.channel.plugin.android.view.youtube.ui.menu.YouTubePlayerMenu;
import com.zoyi.channel.plugin.android.view.youtube.ui.menu.defaultMenu.DefaultYouTubePlayerMenu;
import com.zoyi.channel.plugin.android.view.youtube.ui.utils.FadeViewHelper;
import com.zoyi.channel.plugin.android.view.youtube.ui.views.CHYouTubePlayerSeekBar;

public class DefaultPlayerUiController
implements PlayerUiController,
YouTubePlayerListener,
YouTubePlayerFullScreenListener,
CHYouTubePlayerSeekBar.YouTubePlayerSeekBarListener {
    private YouTubePlayerMenu youTubePlayerMenu;
    private YouTubePlayer youTubePlayer;
    private View panel;
    private View controlsContainer;
    private LinearLayout extraViewsContainer;
    private TextView videoTitle;
    private TextView liveVideoIndicator;
    private CircularProgressView progressBar;
    private ImageView menuButton;
    private ImageView playPauseButton;
    private ImageView youTubeButton;
    private ImageView fullScreenButton;
    private ImageView customActionLeft;
    private ImageView customActionRight;
    private CHYouTubePlayerSeekBar seekYoutubePlayer;
    private View.OnClickListener onFullScreenButtonListener;
    private View.OnClickListener onMenuButtonClickListener;
    private FadeViewHelper fadeControlsContainer;
    private boolean isPlaying = false;
    private boolean isPlayPauseButtonEnabled = true;
    private boolean isCustomActionLeftEnabled = false;
    private boolean isCustomActionRightEnabled = false;

    public DefaultPlayerUiController(LegacyYouTubePlayerView youTubePlayerView, YouTubePlayer youTubePlayer) {
        this.init(youTubePlayerView, youTubePlayer);
    }

    @Initializer
    private void init(LegacyYouTubePlayerView youTubePlayerView, YouTubePlayer youTubePlayer) {
        View controlsView = View.inflate((Context)youTubePlayerView.getContext(), (int)R.layout.ch_plugin_ayp_default_player_ui, (ViewGroup)youTubePlayerView);
        this.youTubePlayer = youTubePlayer;
        this.youTubePlayerMenu = new DefaultYouTubePlayerMenu(youTubePlayerView.getContext());
        this.panel = controlsView.findViewById(R.id.ch_viewAypPanel);
        this.controlsContainer = controlsView.findViewById(R.id.ch_layoutAypControlsContainer);
        this.extraViewsContainer = (LinearLayout)controlsView.findViewById(R.id.ch_layoutAypExtraViewsContainer);
        this.videoTitle = (TextView)controlsView.findViewById(R.id.ch_textAypVideoTitle);
        this.liveVideoIndicator = (TextView)controlsView.findViewById(R.id.ch_textAypLiveVideoIndicator);
        this.progressBar = (CircularProgressView)controlsView.findViewById(R.id.ch_progressAyp);
        this.menuButton = (ImageView)controlsView.findViewById(R.id.ch_imageAypMenuButton);
        this.playPauseButton = (ImageView)controlsView.findViewById(R.id.ch_imageAypPlayPauseButton);
        this.youTubeButton = (ImageView)controlsView.findViewById(R.id.ch_imageAypYoutubeButton);
        this.fullScreenButton = (ImageView)controlsView.findViewById(R.id.ch_imageFullScreenButton);
        this.customActionLeft = (ImageView)controlsView.findViewById(R.id.ch_imageCustomActionLeftButton);
        this.customActionRight = (ImageView)controlsView.findViewById(R.id.ch_imageCustomActionRightButton);
        this.seekYoutubePlayer = (CHYouTubePlayerSeekBar)controlsView.findViewById(R.id.ch_seekAypYoutubePlayer);
        this.fadeControlsContainer = new FadeViewHelper(this.controlsContainer);
        this.onFullScreenButtonListener = view -> youTubePlayerView.toggleFullScreen();
        this.onMenuButtonClickListener = view -> this.youTubePlayerMenu.show((View)this.menuButton);
        this.initClickListeners();
    }

    private void initClickListeners() {
        this.youTubePlayer.addListener(this.seekYoutubePlayer);
        this.youTubePlayer.addListener(this.fadeControlsContainer);
        this.seekYoutubePlayer.setYoutubePlayerSeekBarListener(this);
        this.panel.setOnClickListener(view -> this.fadeControlsContainer.toggleVisibility());
        this.playPauseButton.setOnClickListener(view -> this.onPlayButtonPressed());
        this.fullScreenButton.setOnClickListener(view -> this.onFullScreenButtonListener.onClick((View)this.fullScreenButton));
        this.menuButton.setOnClickListener(view -> this.onMenuButtonClickListener.onClick((View)this.menuButton));
    }

    @Override
    public PlayerUiController showVideoTitle(boolean show) {
        this.videoTitle.setVisibility(show ? 0 : 8);
        return this;
    }

    @Override
    public PlayerUiController setVideoTitle(String videoTitle) {
        this.videoTitle.setText((CharSequence)videoTitle);
        return this;
    }

    @Override
    public PlayerUiController showUi(boolean show) {
        this.fadeControlsContainer.setDisabled(!show);
        this.controlsContainer.setVisibility(show ? 0 : 4);
        return this;
    }

    @Override
    public PlayerUiController showPlayPauseButton(boolean show) {
        this.playPauseButton.setVisibility(show ? 0 : 8);
        this.isPlayPauseButtonEnabled = show;
        return this;
    }

    @Override
    public PlayerUiController enableLiveVideoUi(boolean enable) {
        this.seekYoutubePlayer.setVisibility(enable ? 4 : 0);
        this.liveVideoIndicator.setVisibility(enable ? 0 : 8);
        return this;
    }

    @Override
    public PlayerUiController setCustomAction1(Drawable icon, @Nullable View.OnClickListener clickListener) {
        this.customActionLeft.setImageDrawable(icon);
        this.customActionLeft.setOnClickListener(clickListener);
        this.showCustomAction1(true);
        return this;
    }

    @Override
    public PlayerUiController setCustomAction2(Drawable icon, @Nullable View.OnClickListener clickListener) {
        this.customActionRight.setImageDrawable(icon);
        this.customActionRight.setOnClickListener(clickListener);
        this.showCustomAction2(true);
        return this;
    }

    @Override
    public PlayerUiController showCustomAction1(boolean show) {
        this.isCustomActionLeftEnabled = show;
        this.customActionLeft.setVisibility(show ? 0 : 8);
        return this;
    }

    @Override
    public PlayerUiController showCustomAction2(boolean show) {
        this.isCustomActionRightEnabled = show;
        this.customActionRight.setVisibility(show ? 0 : 8);
        return this;
    }

    @Override
    public PlayerUiController showMenuButton(boolean show) {
        this.menuButton.setVisibility(show ? 0 : 8);
        return this;
    }

    @Override
    public PlayerUiController setMenuButtonClickListener(View.OnClickListener customMenuButtonClickListener) {
        this.onMenuButtonClickListener = customMenuButtonClickListener;
        return this;
    }

    @Override
    public PlayerUiController showCurrentTime(boolean show) {
        this.seekYoutubePlayer.setVisibility(show ? 0 : 8);
        return this;
    }

    @Override
    public PlayerUiController showDuration(boolean show) {
        this.seekYoutubePlayer.getVideoDurationTextView().setVisibility(show ? 0 : 8);
        return this;
    }

    @Override
    public PlayerUiController showSeekBar(boolean show) {
        this.seekYoutubePlayer.getSeekBar().setVisibility(show ? 0 : 4);
        return this;
    }

    @Override
    public PlayerUiController showFullscreenButton(boolean show) {
        this.fullScreenButton.setVisibility(show ? 0 : 8);
        return this;
    }

    @Override
    public PlayerUiController setFullScreenButtonClickListener(View.OnClickListener customFullScreenButtonClickListener) {
        this.onFullScreenButtonListener = customFullScreenButtonClickListener;
        return this;
    }

    @Override
    public PlayerUiController showBufferingProgress(boolean show) {
        this.seekYoutubePlayer.setShowBufferingProgress(show);
        return this;
    }

    @Override
    public PlayerUiController showYouTubeButton(boolean show) {
        this.youTubeButton.setVisibility(show ? 0 : 8);
        return this;
    }

    @Override
    public PlayerUiController addView(View view) {
        this.extraViewsContainer.addView(view, 0);
        return this;
    }

    @Override
    public PlayerUiController removeView(View view) {
        this.extraViewsContainer.removeView(view);
        return this;
    }

    @Override
    @Nullable
    public YouTubePlayerMenu getMenu() {
        return this.youTubePlayerMenu;
    }

    private void onPlayButtonPressed() {
        if (this.isPlaying) {
            this.youTubePlayer.pause();
        } else {
            this.youTubePlayer.play();
        }
    }

    @Override
    public void onYouTubePlayerEnterFullScreen() {
        this.fullScreenButton.setImageResource(R.drawable.ch_plugin_ayp_ic_fullscreen_exit_24dp);
    }

    @Override
    public void onYouTubePlayerExitFullScreen() {
        this.fullScreenButton.setImageResource(R.drawable.ch_plugin_ayp_ic_fullscreen_24dp);
    }

    private void updateState(PlayerConstants.PlayerState state) {
        switch (state) {
            case ENDED: 
            case PAUSED: {
                this.isPlaying = false;
                break;
            }
            case PLAYING: {
                this.isPlaying = true;
                break;
            }
        }
        this.updatePlayPauseButtonIcon(!this.isPlaying);
    }

    private void updatePlayPauseButtonIcon(boolean playing) {
        this.playPauseButton.setImageResource(playing ? R.drawable.ch_plugin_ayp_ic_pause_36dp : R.drawable.ch_plugin_ayp_ic_play_36dp);
    }

    @Override
    public void seekTo(float time) {
        this.youTubePlayer.seekTo(time);
    }

    @Override
    public void onStateChange(YouTubePlayer youTubePlayer, PlayerConstants.PlayerState state) {
        this.updateState(state);
        if (state == PlayerConstants.PlayerState.PLAYING || state == PlayerConstants.PlayerState.PAUSED || state == PlayerConstants.PlayerState.VIDEO_CUED) {
            this.panel.setBackgroundColor(ContextCompat.getColor((Context)this.panel.getContext(), (int)17170445));
            this.progressBar.setVisibility(8);
            if (this.isPlayPauseButtonEnabled) {
                this.playPauseButton.setVisibility(0);
            }
            if (this.isCustomActionLeftEnabled) {
                this.customActionLeft.setVisibility(0);
            }
            if (this.isCustomActionRightEnabled) {
                this.customActionRight.setVisibility(0);
            }
            this.updatePlayPauseButtonIcon(state == PlayerConstants.PlayerState.PLAYING);
        } else {
            this.updatePlayPauseButtonIcon(false);
            if (state == PlayerConstants.PlayerState.BUFFERING) {
                this.progressBar.setVisibility(0);
                this.panel.setBackgroundColor(ContextCompat.getColor((Context)this.panel.getContext(), (int)17170445));
                if (this.isPlayPauseButtonEnabled) {
                    this.playPauseButton.setVisibility(4);
                }
                this.customActionLeft.setVisibility(8);
                this.customActionRight.setVisibility(8);
            }
            if (state == PlayerConstants.PlayerState.UNSTARTED) {
                this.progressBar.setVisibility(8);
                if (this.isPlayPauseButtonEnabled) {
                    this.playPauseButton.setVisibility(0);
                }
            }
        }
    }

    @Override
    public void onVideoId(YouTubePlayer youTubePlayer, String videoId) {
        this.youTubeButton.setOnClickListener(view -> {
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)("http://www.youtube.com/watch?v=" + videoId + "#t=" + this.seekYoutubePlayer.getSeekBar().getProgress())));
            try {
                this.youTubeButton.getContext().startActivity(intent);
            }
            catch (Exception e) {
                L.e(e.getMessage() == null ? "Can't open url to YouTube" : e.getMessage());
            }
        });
    }

    @Override
    public void onReady(YouTubePlayer youTubePlayer) {
    }

    @Override
    public void onPlaybackQualityChange(YouTubePlayer youTubePlayer, PlayerConstants.PlaybackQuality playbackQuality) {
    }

    @Override
    public void onPlaybackRateChange(YouTubePlayer youTubePlayer, PlayerConstants.PlaybackRate playbackRate) {
    }

    @Override
    public void onError(YouTubePlayer youTubePlayer, PlayerConstants.PlayerError error) {
    }

    @Override
    public void onCurrentSecond(YouTubePlayer youTubePlayer, float second) {
    }

    @Override
    public void onVideoDuration(YouTubePlayer youTubePlayer, float duration) {
    }

    @Override
    public void onVideoLoadedFraction(YouTubePlayer youTubePlayer, float loadedFraction) {
    }

    @Override
    public void onApiChange(YouTubePlayer youTubePlayer) {
    }
}

