/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.view.media_thumbnail;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnAttachmentContentActionListener;
import com.zoyi.channel.plugin.android.model.rest.File;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.Utils;
import com.zoyi.channel.plugin.android.view.media_thumbnail.MediaThumbnailView;
import com.zoyi.channel.plugin.android.view.video_player.AttachmentVideoPlayerView;
import java.util.concurrent.TimeUnit;

public class AttachmentMediaThumbnailView
extends MediaThumbnailView {
    private Context context;
    @Nullable
    private String messageId;
    @Nullable
    private File attachment = null;
    @Nullable
    private OnAttachmentContentActionListener listener = null;

    public AttachmentMediaThumbnailView(@NonNull Context context) {
        super(context);
        this.init(context);
    }

    public AttachmentMediaThumbnailView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public AttachmentMediaThumbnailView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    private void init(Context context) {
        this.context = context;
        this.setBorderRadius(Float.valueOf(Utils.dpToPx(context, 6.0f)));
        this.setBorderWidth(Utils.dpToPx(context, 1.0f));
        this.setBorderColor(ResUtils.getColor(context, R.color.ch_grey300));
    }

    public void setAttachment(@Nullable String messageId, File attachment, @Nullable OnAttachmentContentActionListener listener) {
        this.messageId = messageId;
        this.attachment = attachment;
        this.listener = listener;
        if (messageId != null && attachment.getUrl() != null) {
            if (attachment.isVideo()) {
                this.activatePlayButton();
                this.activateDuration(attachment.getDuration() * (double)TimeUnit.SECONDS.toMillis(1L));
            } else if (attachment.isImage()) {
                this.setOnClickListener(v -> {
                    if (this.listener != null && this.attachment != null) {
                        this.listener.onAttachmentClick(this.attachment);
                    }
                });
            }
            this.setOnLongClickListener(v -> {
                if (this.listener != null && this.attachment != null) {
                    this.listener.onAttachmentLongClick(this.attachment);
                    return true;
                }
                return false;
            });
        }
    }

    @Override
    public void onPlayClick() {
        if (this.attachment != null) {
            super.onPlayClick();
            AttachmentVideoPlayerView view = new AttachmentVideoPlayerView(this.context).setUrl(this.messageId, this.attachment, this.listener, null);
            view.setOnLongClickListener(v -> {
                if (this.listener != null && this.attachment != null) {
                    this.listener.onAttachmentLongClick(this.attachment);
                    return true;
                }
                return false;
            });
            if (this.listener != null) {
                this.listener.onAttachmentActionClick();
            }
            this.appendVideoView(view);
        }
    }

    @Override
    public void clear() {
        super.clear();
        this.attachment = null;
        this.listener = null;
        this.setOnClickListener(null);
        this.setOnLongClickListener(null);
    }
}

