/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.util;

import android.support.annotation.Nullable;
import com.zoyi.channel.plugin.android.model.rest.TimeRange;
import com.zoyi.channel.plugin.android.util.lang.DateUtils;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class TimeUtils {
    public static final SimpleDateFormat FULL_YEAR = new SimpleDateFormat("yyyy", Locale.getDefault());
    public static final SimpleDateFormat FULL_DAY = new SimpleDateFormat("yyyy-MM-dd", Locale.getDefault());
    public static final SimpleDateFormat FULL_MINUTE = new SimpleDateFormat("yyyy-MM-dd HH:mm", Locale.getDefault());
    public static final SimpleDateFormat SIMPLE_DAY = new SimpleDateFormat("yyyy-M-d", Locale.getDefault());
    public static final SimpleDateFormat SIMPLE_DATE = new SimpleDateFormat("M/d", Locale.getDefault());
    public static final SimpleDateFormat SIMPLE_YEAR = new SimpleDateFormat("yy/M/d", Locale.getDefault());
    public static final SimpleDateFormat SECOND = new SimpleDateFormat("HH:mm:ss", Locale.getDefault());
    public static final SimpleDateFormat MINUTE_24 = new SimpleDateFormat("H:mm", Locale.getDefault());
    public static final SimpleDateFormat MINUTE_12 = new SimpleDateFormat("h:mm", Locale.getDefault());
    public static final SimpleDateFormat YEAR_DATE = new SimpleDateFormat("yyyy-MM-dd", Locale.US);
    public static final SimpleDateFormat TIME_12 = new SimpleDateFormat("hh:mm a", Locale.US);
    public static final Long MAX_MICROSECONDS = 10000000000000000L;
    public static long TIME_ZONE_OFFSET = 0L;
    public static long SERVER_TIME_OFFSET = 0L;
    private static final int ONE_MINUTE = 60;
    private static final int ONE_HOUR = 3600;
    private static final int ONE_DAY = 86400;
    private static final int ONE_WEEK = 604800;
    private static final int ONE_MONTH = 2592000;
    private static final int ONE_YEAR = 31536000;

    public static void refreshOffset() {
        TIME_ZONE_OFFSET = TimeZone.getDefault().getRawOffset();
    }

    public static void syncServerTime(long serverTime) {
        SERVER_TIME_OFFSET = serverTime - System.currentTimeMillis();
    }

    public static long getCurrentTime() {
        return System.currentTimeMillis() + SERVER_TIME_OFFSET;
    }

    public static String get(SimpleDateFormat format, Long ts) {
        return TimeUtils.get(format, new Date(ts));
    }

    public static String get(SimpleDateFormat format, Date date) {
        return format.format(date);
    }

    public static String get(Long ts) {
        if (ts == null) {
            return "";
        }
        Date date = new Date(ts);
        Date now = new Date(TimeUtils.getCurrentTime());
        if (DateUtils.isSameDay(now, date)) {
            return TimeUtils.getTime(date);
        }
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(date);
        Calendar cal2 = Calendar.getInstance();
        cal2.setTime(now);
        int year1 = cal1.get(1) - 1900;
        int year2 = cal2.get(1) - 1900;
        if (year1 == year2) {
            return TimeUtils.get(SIMPLE_DATE, date);
        }
        return TimeUtils.get(FULL_DAY, date);
    }

    public static String getTime(Long ts) {
        if (ts == null || ts == 0L) {
            return "";
        }
        return TimeUtils.getTime(new Date(ts));
    }

    public static String getTime(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        String time = TimeUtils.get(MINUTE_12, date);
        return String.format("%s %s", time, cal.get(9) == 1 ? "PM" : "AM");
    }

    public static String getFullYear(Long ts) {
        String date = TimeUtils.get(SIMPLE_DAY, ts);
        String time = TimeUtils.getTime(ts);
        return String.format("%s %s", date, time);
    }

    public static String getTimeRangeString(TimeRange timeRange) {
        return String.format("%s ~ %s", TimeUtils.getTime(timeRange.getFrom()), TimeUtils.getTime(timeRange.getTo()));
    }

    private static String getTime(int time) {
        time = Math.max(time, 0);
        time = Math.min(time, 1439);
        int hour = time / 60;
        int minute = time % 60;
        String add = hour < 12 ? "AM" : "PM";
        return String.format("%02d:%02d %s", hour > 12 ? hour - 12 : hour, minute, add);
    }

    public static String formatDatetime(@Nullable Long timestamp) {
        if (timestamp == null || timestamp == 0L) {
            return "";
        }
        return String.format(Locale.US, "%s %s", YEAR_DATE.format(new Date(timestamp)), TIME_12.format(new Date(timestamp)));
    }
}

