/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.operators;

import com.zoyi.rx.Completable;
import com.zoyi.rx.CompletableSubscriber;
import com.zoyi.rx.Subscription;
import com.zoyi.rx.subscriptions.SerialSubscription;
import java.util.concurrent.atomic.AtomicInteger;

public final class CompletableOnSubscribeConcatArray
implements Completable.OnSubscribe {
    final Completable[] sources;

    public CompletableOnSubscribeConcatArray(Completable[] sources) {
        this.sources = sources;
    }

    public void call(CompletableSubscriber s) {
        ConcatInnerSubscriber inner = new ConcatInnerSubscriber(s, this.sources);
        s.onSubscribe(inner.sd);
        inner.next();
    }

    static final class ConcatInnerSubscriber
    extends AtomicInteger
    implements CompletableSubscriber {
        private static final long serialVersionUID = -7965400327305809232L;
        final CompletableSubscriber actual;
        final Completable[] sources;
        int index;
        final SerialSubscription sd;

        public ConcatInnerSubscriber(CompletableSubscriber actual, Completable[] sources) {
            this.actual = actual;
            this.sources = sources;
            this.sd = new SerialSubscription();
        }

        public void onSubscribe(Subscription d) {
            this.sd.set(d);
        }

        public void onError(Throwable e) {
            this.actual.onError(e);
        }

        public void onCompleted() {
            this.next();
        }

        void next() {
            if (this.sd.isUnsubscribed()) {
                return;
            }
            if (this.getAndIncrement() != 0) {
                return;
            }
            Completable[] a = this.sources;
            do {
                int idx;
                if (this.sd.isUnsubscribed()) {
                    return;
                }
                ++this.index;
                if (idx == a.length) {
                    this.actual.onCompleted();
                    return;
                }
                a[idx].unsafeSubscribe(this);
            } while (this.decrementAndGet() != 0);
        }
    }
}

