/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mint.network.http;

import com.splunk.mint.Logger;
import com.splunk.mint.network.util.ReflectionUtil;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;

public abstract class URLStreamHandlerBase
extends URLStreamHandler {
    static final Class<?>[] SIMPLE_FIELD_TYPES = new Class[]{URL.class, Integer.TYPE};
    static final Class<?>[] PROXY_FIELD_TYPES = new Class[]{URL.class, Integer.TYPE, Proxy.class};
    private Constructor<?> proxyConstructor;
    private Constructor<?> simpleConstructor;

    public URLStreamHandlerBase(String[] factoryClasses) throws ClassNotFoundException {
        this.initConstructors(factoryClasses);
        if (this.proxyConstructor == null || this.simpleConstructor == null) {
            throw new ClassNotFoundException("No implementation detected");
        }
    }

    private void initConstructors(String[] factoryClasses) {
        for (String className : factoryClasses) {
            try {
                this.proxyConstructor = ReflectionUtil.findConstructor(className, PROXY_FIELD_TYPES);
                if (this.proxyConstructor != null) {
                    // empty if block
                }
                this.simpleConstructor = ReflectionUtil.findConstructor(className, SIMPLE_FIELD_TYPES);
                if (this.simpleConstructor != null) {
                    // empty if block
                }
                this.proxyConstructor.setAccessible(true);
                this.simpleConstructor.setAccessible(true);
                return;
            }
            catch (ClassNotFoundException e) {
                this.proxyConstructor = null;
                this.simpleConstructor = null;
            }
        }
    }

    @Override
    protected URLConnection openConnection(URL url) throws IOException {
        try {
            return (URLConnection)this.simpleConstructor.newInstance(url, this.getDefaultPort());
        }
        catch (InstantiationException e) {
            Logger.logError("Error initializing connection - can't instantiate object: " + e.getMessage());
            throw new IOException();
        }
        catch (IllegalAccessException e) {
            Logger.logError("Error initializing connection - can't access constructor: " + e.getMessage());
            throw new IOException();
        }
        catch (IllegalArgumentException e) {
            Logger.logError("Error initializing connection - invalid argument: " + e.getMessage());
            throw new IOException();
        }
        catch (InvocationTargetException e) {
            Logger.logError("Error initializing connection - can't invoke target: " + e.getMessage());
            throw new IOException();
        }
    }

    @Override
    protected URLConnection openConnection(URL url, Proxy proxy) throws IOException {
        if (proxy == null) {
            return this.openConnection(url);
        }
        try {
            return (URLConnection)this.proxyConstructor.newInstance(url, this.getDefaultPort(), proxy);
        }
        catch (InstantiationException e) {
            Logger.logError("Error initializing connection - can't instantiate object: " + e.getMessage());
            throw new IOException();
        }
        catch (IllegalAccessException e) {
            Logger.logError("Error initializing connection - can't access constructor: " + e.getMessage());
            throw new IOException();
        }
        catch (IllegalArgumentException e) {
            Logger.logError("Error initializing connection - invalid argument: " + e.getMessage());
            throw new IOException();
        }
        catch (InvocationTargetException e) {
            Logger.logError("Error initializing connection - can't invoke target: " + e.getMessage());
            throw new IOException();
        }
    }

    @Override
    public abstract int getDefaultPort();

    public abstract String getProtocol();
}

